% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data_list.R
\name{default_hyperpars}
\alias{default_hyperpars}
\title{Get default values for hyperparameters
Prints the list of default values for the hyperparameters}
\usage{
default_hyperpars(family = "gaussian", link = "identity", nranef = NULL)
}
\arguments{
\item{family}{distribution family of the analysis model
(\code{gaussian}, \code{binomial}, \code{poisson} or \code{Gamma})}

\item{link}{link function (if the link is already given in the family,
e.g. \code{family = binomial("logit"))} this argument does not
need to be specified}

\item{nranef}{number of random effects}
}
\description{
Get default values for hyperparameters
Prints the list of default values for the hyperparameters
}
\section{Value}{

A list containing the default hyperparameters for JointAI models. The elements
of the list are

\strong{analysis_model:} hyperparameters for the analysis model
\tabular{ll}{
\code{mu_reg_main} \tab mean in the priors for regression coefficients\cr
\code{tau_reg_main} \tab precision in the priors for regression coefficients\cr
\code{a_tau_main} \tab scale parameter in gamma prior for precision of outcome\cr
\code{b_tau_main} \tab rate parameter in gamma prior for precision of outcome\cr
}

\strong{Z:} hyperparameters for the random effects in mixed models
\tabular{ll}{
\code{RinvD} \tab scale matrix in Wishart prior (*) for random effects covariance matrix\cr
\code{KinvD} \tab degrees of freedom in Wishart prior for random effects covariance matrix\cr
\code{a_diag_RinvD} \tab scale parameter in gamma prior for the diagonal elements of \code{RinvD}\cr
\code{b_diag_RinvD} \tab rate parameter in gamma prior for the diagonal elements of \code{RinvD}\cr
}
(*) when there is only one random effect a gamma distribution is used instead of the Wishart

\strong{norm:} hyperparameters for normal and lognormal imputation models
\tabular{ll}{
\code{mu_reg_norm} \tab mean in the priors for regression coefficients\cr
\code{tau_reg_norm} \tab precision in the priors for regression coefficients\cr
\code{a_tau_norm} \tab scale parameter in gamma prior for precision of imputed variable\cr
\code{b_tau_norm} \tab rate parameter in gamma prior for precision of imputed variable\cr
}

\strong{gamma:} hyperparameters for gamma imputation models
\tabular{ll}{
\code{mu_reg_gamma} \tab mean in the priors for regression coefficients\cr
\code{tau_reg_gamma} \tab precision in the priors for regression coefficients\cr
\code{a_tau_gamma} \tab scale parameter in gamma prior for precision of imputed variable\cr
\code{b_tau_gamma} \tab rate parameter in gamma prior for precision of imputed variable\cr
}

\strong{beta:} hyperparameters for beta imputation models
\tabular{ll}{
\code{mu_reg_beta} \tab mean in the priors for regression coefficients\cr
\code{tau_reg_beta} \tab precision in the priors for regression coefficients\cr
\code{a_tau_beta} \tab scale parameter in gamma prior for precision of imputed variable\cr
\code{b_tau_beta} \tab rate parameter in gamma prior for precision of imputed variable\cr
}

\strong{logit:} hyperparameters for logistic imputation models
\tabular{ll}{
\code{mu_reg_logit} \tab mean in the priors for regression coefficients\cr
\code{tau_reg_logit} \tab precision in the priors for regression coefficients\cr
}

\strong{multinomial:} hyperparameters for multinomial imputation models
\tabular{ll}{
\code{mu_reg_multinomial} \tab mean in the priors for regression coefficients\cr
\code{tau_reg_multinomial} \tab precision in the priors for regression coefficients\cr
}

\strong{ordinal:} hyperparameters for ordinal imputation models
\tabular{ll}{
\code{mu_reg_ordinal} \tab mean in the priors for regression coefficients\cr
\code{tau_reg_ordinal} \tab precision in the priors for regression coefficients\cr
\code{mu_delta_ordinal} \tab mean in the prior for the intercepts\cr
\code{tau_delta_ordinal} \tab precision in the priors for the intercepts\cr
}
}

