/*
 * Decompiled with CFR 0.152.
 */
package jas;

import jas.CP;
import jas.ClassEnv;
import jas.CodeAttr;
import jas.ExceptAttr;
import jas.jasError;
import java.io.DataOutputStream;
import java.io.IOException;

public class Method {
    short acc;
    CP name;
    CP sig;
    CodeAttr code;
    ExceptAttr excepts;

    public Method(short macc, CP name, CP sig, CodeAttr cd, ExceptAttr ex) {
        this.acc = macc;
        this.name = name;
        this.sig = sig;
        this.code = cd;
        this.excepts = ex;
    }

    void resolve(ClassEnv e) {
        e.addCPItem(this.name);
        e.addCPItem(this.sig);
        if (this.code != null) {
            this.code.resolve(e);
        }
        if (this.excepts != null) {
            this.excepts.resolve(e);
        }
    }

    void write(ClassEnv e, DataOutputStream out) throws IOException, jasError {
        int cnt = 0;
        out.writeShort(this.acc);
        out.writeShort(e.getCPIndex(this.name));
        out.writeShort(e.getCPIndex(this.sig));
        if (this.code != null) {
            cnt = (short)(cnt + 1);
        }
        if (this.excepts != null) {
            cnt = (short)(cnt + 1);
        }
        out.writeShort(cnt);
        if (this.code != null) {
            this.code.write(e, out);
        }
        if (this.excepts != null) {
            this.excepts.write(e, out);
        }
    }
}

