% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbase.R
\name{cbase}
\alias{cbase}
\title{Compute a circular B-spline basis matrix}
\usage{
cbase(x, xl = min(x), xr = max(x), nseg = 10, bdeg = 3)
}
\arguments{
\item{x}{a vector of argument values, at which the B-spline basis functions
are to be evaluated.}

\item{xl}{the lower limit of the domain of x; default is \code{min(x)}.}

\item{xr}{the upper limit of the domain of x; default is \code{max(x)}.}

\item{nseg}{the number of B-spline segments (default 10) between xl and xr.}

\item{bdeg}{the degree of the basis, usually 1, 2, or 3 (default).}
}
\value{
A matrix with \code{length(x)} rows and \code{nseg} columns.
}
\description{
Computes a circular B-spline basis matrix using evenly spaced knots.
}
\details{
If \code{xl} is larger than \code{min(x)}, it wil be adjusted to \code{min(x)} and a warning wil be given.
If \code{xr} is smaller than \code{max(x)}, it wil be adjusted to \code{max(x)} and a warning wil be given.

The design parameters \code{x, xl, xr, ndeg, bdeg} and \code{type = 'cbase'} are added to the list of attributes.

In a circular basis, the B-splines are wrapped around the boundaries of the domain. Use a circular basis for data
like directions or angles. It should be combined with a circular penalty matrix, as computed by \code{cdiff()}.
}
\examples{
# Compute and plot a circular B-spline basis matrix
x = seq(0, 360, by = 2)
B = cbase(x, 0, 360, nseg = 8, bdeg = 3)
matplot(x, B, type = 'l', lty = 1, lwd = 2, xlab = 'x', ylab = '')
title('Note how the ends connect smoothly meet at boundaries' )

}
\references{
Eilers, P.H.C. and Marx, B.D. (2021). \emph{Practical Smoothing, The Joys of
P-splines.} Cambridge University Press.

Eilers, P.H.C., Marx, B.D., and Durban, M.
(2015). Twenty years of P-splines, \emph{SORT}, 39(2): 149-186.
}
\author{
Paul Eilers and Brian Marx
}
