/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.toolkit;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.JWindow;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.ibase.Common;

public class SplashScreen
extends JWindow
implements Runnable {
    private Thread thread;
    private Dimension screenSize = Common.getScreenRes();
    private Dimension splashSize = new Dimension(300, 200);
    private Image splash;

    public SplashScreen() {
        try {
            this.splash = this.loadSplash("splash.jpg");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setSize(this.splashSize);
        this.setLocation((this.screenSize.width - 300) / 2, (this.screenSize.height - 200) / 2);
        this.setBackground(Color.white);
        this.thread = new Thread(this);
    }

    public void paint(Graphics graphics) {
        try {
            if (this.splash != null) {
                graphics.drawImage(this.splash, 0, 0, this.splash.getWidth(this), this.splash.getHeight(this), this);
            }
            graphics.setFont(new Font("Dialog", 1, 26));
            graphics.drawString("JGR", 175, 40);
            graphics.setFont(new Font("Dialog", 1, 16));
            graphics.drawString("Java Gui for R", 150, 70);
            graphics.setFont(new Font("Dialog", 0, 11));
            graphics.drawString("Version: 1.4", 175, 85);
            graphics.setFont(new Font("Dialog", 2, 13));
            graphics.drawString("Markus Helbig", 163, 119);
            graphics.drawString("Simon Urbanek", 160, 135);
            graphics.setFont(new Font("Dialog", 0, 12));
            graphics.setColor(Color.blue);
            graphics.drawString("http://www.rosuda.org", 150, this.splashSize.height - 35);
            graphics.setColor(Color.black);
            graphics.setFont(new Font("Dialog", 0, 12));
            graphics.drawString("(c) 2003 - 2006, RoSuDa, Univ. Augsburg", 10, this.splashSize.height - 10);
            graphics.drawRect(0, 0, this.splashSize.width - 1, this.splashSize.height - 1);
        }
        catch (Exception exception) {
            graphics.setFont(new Font("Dialog", 0, 12));
            graphics.drawString("SplashScreen (something has gone wrong)", 10, 10);
            new ErrorMsg(exception);
        }
    }

    public Image loadSplash(String string) {
        URL uRL = this.getClass().getResource("/" + string);
        Image image = Toolkit.getDefaultToolkit().getImage(uRL);
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
        return image;
    }

    public void start() {
        this.setVisible(true);
        this.thread.start();
    }

    public void run() {
        while (this.thread != null) {
        }
    }

    public void stop() {
        this.setVisible(false);
        this.dispose();
        this.thread = null;
    }
}

