% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_joint_poles.R
\name{plot_joint_poles}
\alias{plot_joint_poles}
\title{plot_joint_poles}
\usage{
plot_joint_poles(
  normal_from_wild,
  planes_mtx,
  area_ls,
  file_name,
  min_dens,
  plane_area
)
}
\arguments{
\item{normal_from_wild}{the output matrix resulting from wildfire search}

\item{planes_mtx}{the list of joints output from calculate_plane function}

\item{area_ls}{the list of joints area output from calculate_planes_area function}

\item{file_name}{Name of the output data file containing joint poles}

\item{min_dens}{the minimum density pole value to be plotted}

\item{plane_area}{minimum value of joint area to be considered in plot}
}
\value{
A Schmidt density plot with maxima values of joints
}
\description{
This function plots on schmidt stereogram selected joints poles, draws density contour
lines and retrieves poles maxima.
Selected joints and poles maxima are saved in working folder.
}
\examples{
\dontrun{

normali_recalc<-Rcpp_wildfire_search(7,normals[,1:3],neighbours)

joint_list_Cpp<-calculate_joints(mesh3d,normali_recalc)

val_area<-calculate_joints_area(normali_recalc)

file_name<-"my_out_file"

max_pole<-0.3

min_area<-1

poles_maxima<-plot_joint_poles(normali_recalc,joint_list_Cpp,val_area,file_name,max_pole,min_area) }

}
