% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrangling_issues.R
\name{new_issues}
\alias{new_issues}
\alias{new_issues.IssueTB}
\alias{new_issues.IssuesTB}
\alias{new_issues.default}
\title{Create a new \code{IssuesTB} object}
\usage{
new_issues(x = list())

\method{new_issues}{IssueTB}(x)

\method{new_issues}{IssuesTB}(x)

\method{new_issues}{default}(x = list())
}
\arguments{
\item{x}{a list containing \code{IssueTB} objects}
}
\value{
a \code{IssuesTB} object.
}
\description{
Create a new \code{IssuesTB} object
}
\examples{

# Empty issue
issues1 <- new_issues()

# Custom issue
issues2 <- new_issues(
    x = new_issue(
        title = "Une autre issue",
        body = "J'ai une question au sujet de...",
        number = 2,
        created_at = Sys.Date()
    )
)

issues3 <- new_issues(x = list(
    new_issue(
        title = "Nouvelle issue",
        body = "Un nouveau bug pour la fonction...",
        state = "open",
        number = 1,
        created_at = Sys.Date()
    ),
    new_issue(
        title = "Une autre issue",
        body = "J'ai une question au sujet de...",
        state = "closed",
        number = 2,
        created_at = Sys.Date()
    )
))
}
