% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ogls.R
\name{ogls}
\alias{ogls}
\alias{ogls.default}
\alias{ogls.other}
\title{Omnivariant Generalised Least-Squares Regression}
\usage{
ogls(x, ...)

\method{ogls}{default}(x, random.effects = FALSE, ...)

\method{ogls}{other}(x, random.effects = FALSE, ...)
}
\arguments{
\item{x}{either a \code{n x (n+1)} matrix obtained by prepending a
vector of alternating \code{X,Y}-values to its covariance
matrix OR an object of class \code{other} with
\code{x$format=6}.}

\item{...}{optional arguments}

\item{random.effects}{logical. If \code{TRUE}, quantifies the
overdispersion associated with the y-intercept of the data.}
}
\value{
a list of the slope and intercept of the best fit line as
    well as their standard errors and covariance.
}
\description{
Linear regression with inter-sample error correlations.
}
\examples{
fn <- system.file('UW137.csv',package='IsoplotR')
UW137 <- read.data(fn,method='other',format=6)
fit <- ogls(UW137)
}
\references{
Daëron, M., 2023. Making the Case for Reconciled
    \eqn{\Delta}47 Calibrations Using Omnivariant Generalized
    Least-Squares Regression (No. EGU23-10066). Copernicus
    Meetings.

Daëron & Vermeesch, in prep. Omnivariant Generalized Least Squares
Regression: Theory, Geochronological Applications, and Making the
Case for Reconciled \eqn{\Delta}47 calibrations, Chemical Geology.
}
\author{
Pieter Vermeesch and Mathieu Daëron
}
