% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age.R
\name{age}
\alias{age}
\alias{age.default}
\alias{age.UPb}
\alias{age.PbPb}
\alias{age.ArAr}
\alias{age.KCa}
\alias{age.UThHe}
\alias{age.fissiontracks}
\alias{age.ThU}
\alias{age.ThPb}
\alias{age.ReOs}
\alias{age.SmNd}
\alias{age.RbSr}
\alias{age.LuHf}
\title{Calculate isotopic ages}
\usage{
age(x, ...)

\method{age}{default}(
  x,
  method = "U238-Pb206",
  exterr = TRUE,
  J = c(NA, NA),
  zeta = c(NA, NA),
  rhoD = c(NA, NA),
  d = diseq(),
  ...
)

\method{age}{UPb}(
  x,
  type = 1,
  exterr = TRUE,
  i = NA,
  sigdig = NA,
  common.Pb = 0,
  discordance = discfilter(),
  ...
)

\method{age}{PbPb}(x, isochron = TRUE, common.Pb = 2, exterr = TRUE, i = NA, sigdig = NA, ...)

\method{age}{ArAr}(x, isochron = FALSE, i2i = TRUE, exterr = TRUE, i = NA, sigdig = NA, ...)

\method{age}{KCa}(x, isochron = FALSE, i2i = TRUE, exterr = TRUE, i = NA, sigdig = NA, ...)

\method{age}{UThHe}(x, isochron = FALSE, central = FALSE, i = NA, sigdig = NA, ...)

\method{age}{fissiontracks}(x, central = FALSE, i = NA, sigdig = NA, exterr = TRUE, ...)

\method{age}{ThU}(
  x,
  isochron = FALSE,
  i2i = TRUE,
  exterr = TRUE,
  i = NA,
  sigdig = NA,
  detritus = 0,
  ...
)

\method{age}{ThPb}(x, isochron = TRUE, i2i = TRUE, exterr = TRUE, i = NA, sigdig = NA, ...)

\method{age}{ReOs}(x, isochron = TRUE, i2i = TRUE, exterr = TRUE, i = NA, sigdig = NA, ...)

\method{age}{SmNd}(x, isochron = TRUE, i2i = TRUE, exterr = TRUE, i = NA, sigdig = NA, ...)

\method{age}{RbSr}(x, isochron = TRUE, i2i = TRUE, exterr = TRUE, i = NA, sigdig = NA, ...)

\method{age}{LuHf}(x, isochron = TRUE, i2i = TRUE, exterr = TRUE, i = NA, sigdig = NA, ...)
}
\arguments{
\item{x}{can be:

\itemize{

\item a scalar containing an isotopic ratio,

\item a two element vector containing an isotopic ratio and its standard
error, or the spontaneous and induced track densities \code{Ns} and
\code{Ni},

\item a four element vector containing \code{Ar40Ar39},
\code{s[Ar40Ar39]}, \code{J}, \code{s[J]},

\item a two element vector containing \code{K40Ca40} and
\code{s[K40Ca40]},

\item a six element vector containing \code{U}, \code{s[U]}, \code{Th},
\code{s[Th]}, \code{He} and \code{s[He]},

\item an eight element vector containing \code{U}, \code{s[U]},
\code{Th}, \code{s[Th]}, \code{He}, \code{s[He]}, \code{Sm} and
\code{s[Sm]}

\item a two element vector containing \code{Sr87Rb87} and
\code{s[Sr87Rb87]}

\item a two element vector containing \code{Os187Re187} and
\code{s[Os187Re187]}

\item a two element vector containing \code{Nd143Sm147} and
\code{s[Nd144Sm147]}

\item a two element vector containing \code{Hf176Lu176} and
\code{s[Hf176Lu176]}

\item a five element vector containing \code{Th230U238}, \code{s[Th230/U238]},
\code{U234U238}, \code{s[U234U238]} and \code{cov[Th230U238,U234U238]}

}

OR

\itemize{ \item an object of class \code{UPb}, \code{PbPb},
\code{ThPb}, \code{ArAr}, \code{KCa}, \code{ThU}, \code{RbSr},
\code{SmNd}, \code{ReOs}, \code{LuHf}, \code{UThHe} or
\code{fissiontracks}.  }}

\item{...}{additional arguments}

\item{method}{one of either \code{'U238-Pb206'},
\code{'U235-Pb207'}, \code{'Pb207-Pb206'},
\code{'Th232-Pb208'}, \code{'Ar-Ar'}, \code{'K-Ca'},
\code{'Th-U'}, \code{'Re-Os'}, \code{'Sm-Nd'}, \code{'Rb-Sr'},
\code{'Lu-Hf'}, \code{'U-Th-He'} or \code{'fissiontracks'}}

\item{exterr}{propagate the external (decay constant and
calibration factor) uncertainties?}

\item{J}{two-element vector with the J-factor and its standard
error.}

\item{zeta}{two-element vector with the zeta-factor and its standard
error.}

\item{rhoD}{two-element vector with the track density of the
dosimeter glass and its standard error.}

\item{d}{an object of class \code{\link{diseq}}.}

\item{type}{scalar flag indicating whether

\code{1}: each U-Pb analysis should be considered separately,

\code{2}: all the measurements should be combined to calculate a
concordia age,

\code{3}: a discordia line should be fitted through all the U-Pb
    analyses using the maximum likelihood algorithm of Ludwig
    (1998), which assumes that the scatter of the data is solely
    due to the analytical uncertainties.

\code{4}: a discordia line should be fitted ignoring the analytical
uncertainties.

\code{5}: a discordia line should be fitted using a modified
maximum likelihood algorithm that accounts for overdispersion by
adding a geological (co)variance term.}

\item{i}{index of a particular aliquot}

\item{sigdig}{number of significant digits for the uncertainty
estimate (only used if \code{type=1}, \code{isochron=FALSE} and
\code{central=FALSE}).}

\item{common.Pb}{common lead correction:

\code{0}: none

\code{1}: use the Pb-composition stored in

\code{settings('iratio','Pb206Pb204')} (if \code{x} has class
\code{UPb} and \code{x$format<4});

\code{settings('iratio','Pb206Pb204')} and
\code{settings('iratio','Pb207Pb204')} (if \code{x} has class
\code{PbPb} or \code{x} has class \code{UPb} and
\code{3<x$format<7}); or

\code{settings('iratio','Pb208Pb206')} and
\code{settings('iratio','Pb208Pb207')} (if \code{x} has class
\code{UPb} and \code{x$format=7} or \code{8}).

\code{2}: use the isochron intercept as the initial Pb-composition

\code{3}: use the Stacey-Kramer two-stage model to infer the initial
Pb-composition}

\item{discordance}{discordance calculator. This is an object of
    class \code{\link{discfilter}}, or a two element list
    containing:

\code{option}: one of

\code{1} or \code{'t'} (absolute age filter);

\code{2} or \code{'r'} (relative age filter);

\code{3} or \code{'sk'} (Stacey-Kramers common Pb filter);

\code{4} or \code{'a'} (perpendicular Aitchison distance);

\code{5} or \code{'c'} (concordia distance);

\code{6} or \code{'p'} (p-value of concordance); or

\code{NA} (omit the discordance from the output)

\code{before}: logical flag indicating whether the discordance
should be calculated before (\code{TRUE}) or after (\code{FALSE})
the common-Pb correction.}

\item{isochron}{logical flag indicating whether each analysis
should be considered separately (\code{isochron=FALSE}) or an
isochron age should be calculated from all analyses together
(\code{isochron=TRUE}).}

\item{i2i}{`isochron to intercept': calculates the initial (aka
`inherited', `excess', or `common')
\eqn{^{40}}Ar/\eqn{^{36}}Ar, \eqn{^{40}}Ca/\eqn{^{44}}Ca,
\eqn{^{87}}Sr/\eqn{^{86}}Sr, \eqn{^{143}}Nd/\eqn{^{144}}Nd,
\eqn{^{187}}Os/\eqn{^{188}}Os, \eqn{^{176}}Hf/\eqn{^{177}}Hf or
\eqn{^{204}}Pb/\eqn{^{208}}Pb ratio from an isochron
fit. Setting \code{i2i} to \code{FALSE} uses the default values
stored in \code{settings('iratio',...)}. When applied to data
of class \code{ThU}, setting \code{i2i} to \code{TRUE} applies
a detrital Th-correction.}

\item{central}{logical flag indicating whether each analysis should
be considered separately (\code{central=FALSE}) or a central
age should be calculated from all analyses together
(\code{central=TRUE}).}

\item{detritus}{detrital \eqn{^{230}}Th correction (only applicable
    when \code{x$format = 1} or \code{2}).

\code{0}: no correction

\code{1}: project the data along an isochron fit

\code{2}: correct the data using an assumed initial
\eqn{^{230}}Th/\eqn{^{232}}Th-ratio for the detritus.

\code{3}: correct the data using the measured present day
\eqn{^{230}}Th/\eqn{^{238}}U, \eqn{^{232}}Th/\eqn{^{238}}U and
\eqn{^{234}}U/\eqn{^{238}}U-ratios in the detritus.}
}
\value{
\enumerate{

\item if \code{x} is a scalar or a vector, returns the age using
the geochronometer given by \code{method} and its standard error.

\item if \code{x} has class \code{UPb} and \code{type=1}, returns a
table with the following columns: \code{t.75}, \code{err[t.75]},
\code{t.68}, \code{err[t.68]}, \code{t.76}, \code{err[t.76]},
(\code{t.82}, \code{err[t.82]},) \code{t.conc}, \code{err[t.conc]},
(\code{disc}) or \code{err[p.conc]},) containing the
\eqn{^{207}}Pb/\eqn{^{235}}U-age and standard error, the
\eqn{^{206}}Pb/\eqn{^{238}}U-age and standard error, the
\eqn{^{207}}Pb/\eqn{^{206}}Pb-age and standard error, (the
\eqn{^{208}}Pb/\eqn{^{232}}Th-age and standard error,) the single
grain concordia age and standard error, (and the \% discordance or
p-value for concordance,) respectively.

\item if \code{x} has class \code{UPb} and \code{type=2, 3, 4} or
\code{5}, returns the output of the \code{\link{concordia}}
function.

\item if \code{x} has class \code{PbPb}, \code{ThPb}, \code{ArAr},
\code{KCa}, \code{RbSr}, \code{SmNd}, \code{ReOs}, \code{LuHf},
\code{ThU} or \code{UThHe} and \code{isochron=FALSE}, returns a
table of Pb-Pb, Th-Pb, Ar-Ar, K-Ca, Rb-Sr, Sm-Nd, Re-Os, Lu-Hf,
Th-U or U-Th-He ages and their standard errors.

\item if \code{x} has class \code{ThU} and \code{isochron=FALSE},
returns a 5-column table with the Th-U ages, their standard errors,
the initial \eqn{^{234}}U/\eqn{^{238}}U-ratios, their standard errors,
and the correlation coefficient between the ages and the initial
ratios.

\item if \code{x} has class \code{PbPb}, \code{ThPb}, \code{ArAr},
\code{KCa}, \code{RbSr}, \code{SmNd}, \code{ReOs}, \code{LuHf},
\code{UThHe} or \code{ThU} and \code{isochron=TRUE}, returns the
output of the \code{\link{isochron}} function.

\item if \code{x} has class \code{fissiontracks} and
\code{central=FALSE}, returns a table of fission track ages and
standard errors.

\item if \code{x} has class \code{fissiontracks} or \code{UThHe}
and \code{central=TRUE}, returns the output of the
\code{\link{central}} function.

}
}
\description{
Calculates U-Pb, Pb-Pb, Th-Pb, Ar-Ar, K-Ca, Re-Os, Sm-Nd, Rb-Sr, Lu-Hf,
U-Th-He, Th-U and fission track ages and propagates their
analytical uncertainties. Includes options for single grain,
isochron and concordia ages.
}
\examples{
data(examples)
tUPb <- age(examples$UPb,type=1)
tconc <- age(examples$UPb,type=2)
tdisc <- age(examples$UPb,type=3)
tArAr <- age(examples$ArAr)
tiso <- age(examples$ArAr,isochron=TRUE,i2i=TRUE)
tcentral <- age(examples$FT1,central=TRUE)
}
\seealso{
\code{\link{concordia}}, \code{\link{isochron}},
    \code{\link{central}}
}
