% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/titterington.R
\name{titterington}
\alias{titterington}
\title{Linear regression of X,Y,Z-variables with correlated errors}
\usage{
titterington(x, alpha = 0.05)
}
\arguments{
\item{x}{a \code{[9 x n]} matrix with the following columns:
\code{X, sX, Y, sY, Z, sZ}, \code{rhoXY, rhoXZ, rhoYZ}.}

\item{alpha}{cutoff value for confidence intervals}
}
\value{
a four-element list of vectors containing:
    \describe{

    \item{par}{4-element vector \code{c(a,b,A,B)} where \code{a} is
              the intercept of the \code{X-Y} regression, \code{b}
              is the slope of the \code{X-Y} regression, \code{A}
              is the intercept of the \code{X-Z} regression, and
              \code{B} is the slope of the \code{X-Z} regression.}

    \item{cov}{\code{[4 x 4]}-element covariance matrix of \code{par}}

    \item{mswd}{the mean square of the residuals (a.k.a `reduced
                Chi-square') statistic}

    \item{p.value}{p-value of a Chi-square test for linearity}

    \item{df}{the number of degrees of freedom for the Chi-square
    test (3\eqn{n}-3)}

    }
}
\description{
Implements the maximum likelihood algorithm of Ludwig and Titterington (1994)
}
\examples{
d <- matrix(c(0.1677,0.0047,1.105,0.014,0.782,0.015,0.24,0.51,0.33,
              0.2820,0.0064,1.081,0.013,0.798,0.015,0.26,0.63,0.32,
              0.3699,0.0076,1.038,0.011,0.819,0.015,0.27,0.69,0.30,
              0.4473,0.0087,1.051,0.011,0.812,0.015,0.27,0.73,0.30,
              0.5065,0.0095,1.049,0.010,0.842,0.015,0.27,0.76,0.29,
              0.5520,0.0100,1.039,0.010,0.862,0.015,0.27,0.78,0.28),
            nrow=6,ncol=9)
colnames(d) <- c('X','sX','Y','sY','Z','sZ','rXY','rXZ','rYZ')
titterington(d)
}
\references{
Ludwig, K.R. and Titterington, D.M., 1994. Calculation
of \eqn{^{230}}Th/U isochrons, ages, and errors. Geochimica et
Cosmochimica Acta, 58(22), pp.5031-5042.
}
