% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helioplot.R
\name{helioplot}
\alias{helioplot}
\title{Visualise U-Th-He data on a logratio plot or ternary diagram}
\usage{
helioplot(x, logratio = TRUE, show.central.comp = TRUE,
  show.numbers = FALSE, alpha = 0.05, contour.col = c("white", "red"),
  levels = NA, ellipse.col = c("#00FF0080", "#0000FF80"), sigdig = 2,
  xlim = NA, ylim = NA, fact = NA, ...)
}
\arguments{
\item{x}{an object of class \code{UThHe}}

\item{logratio}{Boolean flag indicating whether the data should be
shown on bivariate log[He/Th] vs. log[U/He] diagramme, or a
U-Th-He ternary diagramme.}

\item{show.central.comp}{show the geometric mean composition as a
white ellipse?}

\item{show.numbers}{show the grain numbers inside the error
ellipses?}

\item{alpha}{probability cutoff for the error ellipses and
confidence intervals}

\item{contour.col}{two-element vector with the fill colours to be
assigned to the minimum and maximum age contour}

\item{levels}{a vector with additional values to be displayed as
different background colours within the error ellipses.}

\item{ellipse.col}{a vector of two background colours for the error
ellipses. If \code{levels=NA}, then only the first colour will
be used. If \code{levels} is a vector of numbers, then
\code{ellipse.col} is used to construct a colour ramp.}

\item{sigdig}{number of significant digits for the central age}

\item{xlim}{optional limits of the x-axis (log[U/He]) of the
logratio plot. If \code{xlim=NA}, the axis limits are
determined automatically.}

\item{ylim}{optional limits of the y-axis (log[Th/He]) of the
logratio plot. If \code{ylim=NA}, the axis limits are
determined automatically.}

\item{fact}{three-element vector with the scaling factors of the
ternary diagram if \code{fact=NA}, these will be determined
automatically}

\item{...}{optional arguments to the generic \code{plot} function}
}
\description{
Plot U-Th(-Sm)-He data on a (log[He/Th] vs. log[U/He]) logratio
plot or U-Th-He ternary diagram
}
\examples{
data(examples)
helioplot(examples$UThHe)
dev.new()
helioplot(examples$UThHe,logratio=FALSE)
}
\references{
Vermeesch, P., 2010. HelioPlot, and the treatment of
    overdispersed (U-Th-Sm)/He data. Chemical Geology, 271(3),
    pp.108-111.
}
