% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mds.R
\name{mds}
\alias{mds}
\alias{mds.default}
\alias{mds.detritals}
\title{Multidimensional Scaling}
\usage{
mds(x, ...)

\method{mds}{default}(x, classical = FALSE, plot = TRUE, shepard = FALSE,
  nnlines = FALSE, pch = 21, pos = NULL, cex.symbols = 2.5,
  col = "black", bg = "white", xlab = "", ylab = "", ...)

\method{mds}{detritals}(x, classical = FALSE, plot = TRUE,
  shepard = FALSE, nnlines = FALSE, pch = 21, pos = NULL,
  cex.symbols = 2.5, col = "black", bg = "white", xlab = "",
  ylab = "", ...)
}
\arguments{
\item{x}{a dissimilarity matrix OR an object of class
\code{detrital}}

\item{...}{optional arguments to the generic \code{plot} function}

\item{classical}{logical flag indicating whether classical
(\code{TRUE}) or nonmetric (\code{FALSE}) MDS should be used}

\item{plot}{show the MDS configuration (if \code{shepard=FALSE}) or
Shepard plot (if \code{shepard=TRUE}) on a graphical device}

\item{shepard}{logical flag indicating whether the graphical output
should show the MDS configuration (\code{shepard=FALSE}) or a
Shepard plot with the 'stress' value. This argument is only
used if \code{plot=TRUE}.}

\item{nnlines}{if \code{TRUE}, draws nearest neighbour lines}

\item{pch}{plot character (see \code{?plot} for details). May be a
vector.}

\item{pos}{a position specifier for the labels (if
\code{pch!=NA}). Values of 1, 2, 3 and 4 indicate positions
below, to the left of, above and to the right of the MDS
coordinates, respectively.}

\item{cex.symbols}{a numerical value giving the amount by which
plotting symbols should be magnified relative to the default}

\item{col}{plot colour (may be a vector)}

\item{bg}{background colour (may be a vector)}

\item{xlab}{a string with the label of the x axis}

\item{ylab}{a string with the label of the y axis}
}
\value{
if \code{plot=FALSE}, returns an object of class
    \code{MDS}, i.e. a list containing the following items:
    \describe{ \item{points}{a two column vector of the fitted
    configuration} \item{classical}{a logical flag indicating
    whether the MDS configuration was obtained by classical
    (\code{TRUE}) or nonmetric (\code{FALSE}) MDS} \item{diss}{the
    dissimilarity matrix used for the MDS analysis}
    \item{stress}{(only if \code{classical=TRUE}) the final stress
    achieved (in percent)} }
}
\description{
Performs classical or nonmetric Multidimensional Scaling analysis
}
\examples{
data(examples)
mds(examples$DZ,nnlines=TRUE,cex=5)
dev.new()
mds(examples$DZ,shepard=TRUE)
}
\references{
Vermeesch, P., 2013. Multi-sample comparison of
    detrital age distributions. Chemical Geology, 341, pp.140-146.
}
