% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fissiontracks.R
\name{set.zeta}
\alias{set.zeta}
\title{Calculate the zeta calibration coefficient for fission track dating}
\usage{
set.zeta(x, tst = c(0, 0), exterr = TRUE, update = TRUE, sigdig = 2)
}
\arguments{
\item{x}{an object of class \code{fissiontracks}}

\item{tst}{a two-element vector with the true age and its standard
error}

\item{exterr}{logical flag indicating whether the external
uncertainties associated with the age standard or the dosimeter
glass (for the EDM) should be accounted for when propagating
the uncertainty of the zeta calibration constant.}

\item{update}{logical flag indicating whether the function should
return an updated version of the input data, or simply return a
two-element vector with the calibration constant and its
standard error.}

\item{sigdig}{number of significant digits}
}
\value{
an object of class \code{fissiontracks} with an updated
    \code{x$zeta} value
}
\description{
Determines the zeta calibration constant of a fission track dataset
(EDM or LA-ICP-MS) given its true age and analytical uncertainty.
}
\examples{
data(examples)
print(examples$FT1$zeta)
FT <- set.zeta(examples$FT1,tst=c(250,5))
print(FT$zeta)
}

