/*
 *   Copyright (C) 2015-2016 Mateusz Łącki and Michał Startek.
 *
 *   This file is part of IsoSpec.
 *
 *   IsoSpec is free software: you can redistribute it and/or modify
 *   it under the terms of the Simplified ("2-clause") BSD licence.
 *
 *   IsoSpec is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 *
 *   You should have received a copy of the Simplified BSD Licence
 *   along with IsoSpec.  If not, see <https://opensource.org/licenses/BSD-2-Clause>.
 */


#include "element_tables.h"

#ifdef __cplusplus
extern "C" {
#endif

const int elem_table_atomicNo [NUMBER_OF_ISOTOPIC_ENTRIES] = {
1,
1,
2,
2,
3,
3,
4,
5,
5,
6,
6,
7,
7,
8,
8,
8,
9,
10,
10,
10,
11,
12,
12,
12,
13,
14,
14,
14,
15,
16,
16,
16,
16,
17,
17,
18,
18,
18,
19,
19,
19,
20,
20,
20,
20,
20,
20,
21,
22,
22,
22,
22,
22,
23,
23,
24,
24,
24,
24,
25,
26,
26,
26,
26,
27,
28,
28,
28,
28,
28,
29,
29,
30,
30,
30,
30,
30,
31,
31,
32,
32,
32,
32,
32,
33,
34,
34,
34,
34,
34,
34,
35,
35,
36,
36,
36,
36,
36,
36,
37,
37,
38,
38,
38,
38,
39,
40,
40,
40,
40,
40,
41,
42,
42,
42,
42,
42,
42,
42,
44,
44,
44,
44,
44,
44,
44,
45,
46,
46,
46,
46,
46,
46,
47,
47,
48,
48,
48,
48,
48,
48,
48,
48,
49,
49,
50,
50,
50,
50,
50,
50,
50,
50,
50,
50,
51,
51,
52,
52,
52,
52,
52,
52,
52,
52,
53,
54,
54,
54,
54,
54,
54,
54,
54,
54,
55,
56,
56,
56,
56,
56,
56,
56,
57,
57,
58,
58,
58,
58,
59,
60,
60,
60,
60,
60,
60,
60,
62,
62,
62,
62,
62,
62,
62,
63,
63,
64,
64,
64,
64,
64,
64,
64,
65,
66,
66,
66,
66,
66,
66,
66,
67,
68,
68,
68,
68,
68,
68,
69,
70,
70,
70,
70,
70,
70,
70,
71,
71,
72,
72,
72,
72,
72,
72,
73,
73,
74,
74,
74,
74,
74,
75,
75,
76,
76,
76,
76,
76,
76,
76,
77,
77,
78,
78,
78,
78,
78,
78,
79,
80,
80,
80,
80,
80,
80,
80,
81,
81,
82,
82,
82,
82,
83,
92,
92,
92,
90,
91,
};


const double elem_table_mass [NUMBER_OF_ISOTOPIC_ENTRIES] = {
1.00782503227,
2.01410177819,
3.016029322,
4.00260325414,
6.0151228871,
7.016003443,
9.01218316,
10.0129373,
11.0093053,
12,
13.0033548352,
14.0030740042,
15.0001088994,
15.9949146202,
16.9991317576,
17.9991596137,
18.9984031637,
19.992440182,
20.99384673,
21.99138512,
22.989769282,
23.985041701,
24.98583703,
25.98259302,
26.98153858,
27.9769265353,
28.9764946653,
29.973770012,
30.9737619986,
31.9720711741,
32.9714589101,
33.96786703,
35.9670812,
34.96885273,
36.96590264,
35.96754512,
37.9627322,
39.962383122,
38.963706493,
39.96399824,
40.961825263,
39.96259092,
41.9586181,
42.9587662,
43.9554822,
45.953692,
47.95252289,
44.9559086,
45.9526283,
46.9517593,
47.9479423,
48.9478663,
49.9447873,
49.9471567,
50.9439577,
49.9460427,
51.9405064,
52.9406484,
53.9388794,
54.9380443,
53.9396093,
55.9349363,
56.9353933,
57.9332743,
58.9331944,
57.9353423,
59.9307863,
60.9310563,
61.9283454,
63.9279674,
62.9295984,
64.9277906,
63.9291426,
65.9260347,
66.9271287,
67.9248457,
69.925322,
68.9255749,
70.9247037,
69.9242497,
71.92207586,
72.92345904,
73.921177761,
75.92140272,
74.9215957,
73.92247591,
75.91921372,
76.91991426,
77.9173092,
79.9165229,
81.9167001,
78.9183381,
80.9162901,
77.9203656,
79.9163786,
81.9134837,
82.9141272,
83.911497733,
85.910610633,
84.911789743,
86.909180536,
83.9134199,
85.9092619,
86.9088789,
87.9056139,
88.905842,
89.904702,
90.905642,
91.905032,
93.906312,
95.908272,
92.906372,
91.9068086,
93.9050853,
94.9058393,
95.9046763,
96.9060183,
97.9054053,
99.9074728,
95.9075903,
97.905296,
98.9059348,
99.9042148,
100.9055779,
101.9043449,
103.905432,
102.905502,
101.905602,
103.9040311,
104.9050809,
105.9034809,
107.9038929,
109.9051726,
106.905092,
108.9047551,
105.9064609,
107.9041839,
109.9030074,
110.9041834,
111.9027634,
112.9044083,
113.9033653,
115.9047632,
112.9040627,
114.903878789,
111.9048244,
113.9027837,
114.90334471,
115.9017431,
116.9029543,
117.9016073,
118.9033116,
119.9022027,
121.903442,
123.9052778,
120.903812,
122.904212,
119.904062,
121.903041,
122.904271,
123.902821,
124.904431,
125.903311,
127.9044617,
129.906222759,
126.904473,
123.905892,
125.904303,
127.9035318,
128.904780864,
129.90350941,
130.9050842,
131.904155094,
133.9053957,
135.907214488,
132.905451967,
129.906322,
131.9050618,
133.9045082,
134.9056882,
135.9045762,
136.9058272,
137.9052472,
137.907123,
138.906362,
135.9071293,
137.905998,
139.905442,
141.909252,
140.907662,
141.907732,
142.909822,
143.910092,
144.912582,
145.913122,
147.916902,
149.920902,
143.912012,
146.914902,
147.914832,
148.917192,
149.917282,
151.919742,
153.922222,
150.919862,
152.921242,
151.919802,
153.920872,
154.922632,
155.922132,
156.923972,
157.924112,
159.927062,
158.925352,
155.924282,
157.924422,
159.925202,
160.926942,
161.926812,
162.928742,
163.929182,
164.930332,
161.928792,
163.929212,
165.930302,
166.932052,
167.932382,
169.935472,
168.934222,
167.933892,
169.934772,
170.936332,
171.936392,
172.938222,
173.938872,
175.942582,
174.940782,
175.942692,
173.940052,
175.941412,
176.943232,
177.943712,
178.945822,
179.946562,
179.947462,
180.948002,
179.946712,
181.9482047,
182.9502237,
183.9509317,
185.954362,
184.9529559,
186.955751,
183.9524891,
185.953841,
186.955751,
187.955841,
188.958142,
189.958442,
191.961482,
190.960592,
192.962922,
189.959934,
191.961042,
193.9626817,
194.9647927,
195.9649527,
197.967892,
196.9665696,
195.965832,
197.9667693,
198.9682813,
199.9683273,
200.9703036,
201.9706436,
203.9734943,
202.9723451,
204.9744281,
203.9730449,
205.9744669,
206.9758979,
207.9766539,
208.980401,
234.040952,
235.043932,
238.050792,
232.038062,
231.035882,
};


const int elem_table_massNo [NUMBER_OF_ISOTOPIC_ENTRIES] = {
1,
2,
3,
4,
6,
7,
9,
10,
11,
12,
13,
14,
15,
16,
17,
18,
19,
20,
21,
22,
23,
24,
25,
26,
27,
28,
29,
30,
31,
32,
33,
34,
36,
35,
37,
36,
38,
40,
39,
40,
41,
40,
42,
43,
44,
46,
48,
45,
46,
47,
48,
49,
50,
50,
51,
50,
52,
53,
54,
55,
54,
56,
57,
58,
59,
58,
60,
61,
62,
64,
63,
65,
64,
66,
67,
68,
70,
69,
71,
70,
72,
73,
74,
76,
75,
74,
76,
77,
78,
80,
82,
79,
81,
78,
80,
82,
83,
84,
86,
85,
87,
84,
86,
87,
88,
89,
90,
91,
92,
94,
96,
93,
92,
94,
95,
96,
97,
98,
100,
96,
98,
99,
100,
101,
102,
104,
103,
102,
104,
105,
106,
108,
110,
107,
109,
106,
108,
110,
111,
112,
113,
114,
116,
113,
115,
112,
114,
115,
116,
117,
118,
119,
120,
122,
124,
121,
123,
120,
122,
123,
124,
125,
126,
128,
130,
127,
124,
126,
128,
129,
130,
131,
132,
134,
136,
133,
130,
132,
134,
135,
136,
137,
138,
138,
139,
136,
138,
140,
142,
141,
142,
143,
144,
145,
146,
148,
150,
144,
147,
148,
149,
150,
152,
154,
151,
153,
152,
154,
155,
156,
157,
158,
160,
159,
156,
158,
160,
161,
162,
163,
164,
165,
162,
164,
166,
167,
168,
170,
169,
168,
170,
171,
172,
173,
174,
176,
175,
176,
174,
176,
177,
178,
179,
180,
180,
181,
180,
182,
183,
184,
186,
185,
187,
184,
186,
187,
188,
189,
190,
192,
191,
193,
190,
192,
194,
195,
196,
198,
197,
196,
198,
199,
200,
201,
202,
204,
203,
205,
204,
206,
207,
208,
209,
234,
235,
238,
232,
231,
};


const int elem_table_extraNeutrons [NUMBER_OF_ISOTOPIC_ENTRIES] = {
0,
1,
0,
1,
0,
1,
0,
0,
1,
0,
1,
0,
1,
0,
1,
2,
0,
0,
1,
2,
0,
0,
1,
2,
0,
0,
1,
2,
0,
0,
1,
2,
4,
0,
2,
0,
2,
4,
0,
1,
2,
0,
2,
3,
4,
6,
8,
0,
0,
1,
2,
3,
4,
0,
1,
0,
2,
3,
4,
0,
0,
2,
3,
4,
0,
0,
2,
3,
4,
6,
0,
2,
0,
2,
3,
4,
6,
0,
2,
0,
2,
3,
4,
6,
0,
0,
2,
3,
4,
6,
8,
0,
2,
0,
2,
4,
5,
6,
8,
0,
2,
0,
2,
3,
4,
0,
0,
1,
2,
4,
6,
0,
0,
2,
3,
4,
5,
6,
8,
0,
2,
3,
4,
5,
6,
8,
0,
0,
2,
3,
4,
6,
8,
0,
2,
0,
2,
4,
5,
6,
7,
8,
10,
0,
2,
0,
2,
3,
4,
5,
6,
7,
8,
10,
12,
0,
2,
0,
2,
3,
4,
5,
6,
8,
10,
0,
0,
2,
4,
5,
6,
7,
8,
10,
12,
0,
0,
2,
4,
5,
6,
7,
8,
0,
1,
0,
2,
4,
6,
0,
0,
1,
2,
3,
4,
6,
8,
0,
3,
4,
5,
6,
8,
10,
0,
2,
0,
2,
3,
4,
5,
6,
8,
0,
0,
2,
4,
5,
6,
7,
8,
0,
0,
2,
4,
5,
6,
8,
0,
0,
2,
3,
4,
5,
6,
8,
0,
1,
0,
2,
3,
4,
5,
6,
0,
1,
0,
2,
3,
4,
6,
0,
2,
0,
2,
3,
4,
5,
6,
8,
0,
2,
0,
2,
4,
5,
6,
8,
0,
0,
2,
3,
4,
5,
6,
8,
0,
2,
0,
2,
3,
4,
0,
1,
2,
5,
0,
0,
};


const char* elem_table_element [NUMBER_OF_ISOTOPIC_ENTRIES] = {
"hydrogen",
"hydrogen",
"helium",
"helium",
"lithium",
"lithium",
"beryllium",
"boron",
"boron",
"carbon",
"carbon",
"nitrogen",
"nitrogen",
"oxygen",
"oxygen",
"oxygen",
"fluorine",
"neon",
"neon",
"neon",
"sodium",
"magnesium",
"magnesium",
"magnesium",
"aluminium",
"silicon",
"silicon",
"silicon",
"phosphorus",
"sulfur",
"sulfur",
"sulfur",
"sulfur",
"chlorine",
"chlorine",
"argon",
"argon",
"argon",
"potassium",
"potassium",
"potassium",
"calcium",
"calcium",
"calcium",
"calcium",
"calcium",
"calcium",
"scandium",
"titanium",
"titanium",
"titanium",
"titanium",
"titanium",
"vanadium",
"vanadium",
"chromium",
"chromium",
"chromium",
"chromium",
"manganese",
"iron",
"iron",
"iron",
"iron",
"cobalt",
"nickel",
"nickel",
"nickel",
"nickel",
"nickel",
"copper",
"copper",
"zinc",
"zinc",
"zinc",
"zinc",
"zinc",
"gallium",
"gallium",
"germanium",
"germanium",
"germanium",
"germanium",
"germanium",
"arsenic",
"selenium",
"selenium",
"selenium",
"selenium",
"selenium",
"selenium",
"bromine",
"bromine",
"krypton",
"krypton",
"krypton",
"krypton",
"krypton",
"krypton",
"rubidium",
"rubidium",
"strontium",
"strontium",
"strontium",
"strontium",
"yttrium",
"zirconium",
"zirconium",
"zirconium",
"zirconium",
"zirconium",
"niobium",
"molybdenum",
"molybdenum",
"molybdenum",
"molybdenum",
"molybdenum",
"molybdenum",
"molybdenum",
"ruthenium",
"ruthenium",
"ruthenium",
"ruthenium",
"ruthenium",
"ruthenium",
"ruthenium",
"rhodium",
"palladium",
"palladium",
"palladium",
"palladium",
"palladium",
"palladium",
"silver",
"silver",
"cadmium",
"cadmium",
"cadmium",
"cadmium",
"cadmium",
"cadmium",
"cadmium",
"cadmium",
"indium",
"indium",
"tin",
"tin",
"tin",
"tin",
"tin",
"tin",
"tin",
"tin",
"tin",
"tin",
"antimony",
"antimony",
"tellurium",
"tellurium",
"tellurium",
"tellurium",
"tellurium",
"tellurium",
"tellurium",
"tellurium",
"iodine",
"xenon",
"xenon",
"xenon",
"xenon",
"xenon",
"xenon",
"xenon",
"xenon",
"xenon",
"caesium",
"barium",
"barium",
"barium",
"barium",
"barium",
"barium",
"barium",
"lanthanum",
"lanthanum",
"cerium",
"cerium",
"cerium",
"cerium",
"praseodymium",
"neodymium",
"neodymium",
"neodymium",
"neodymium",
"neodymium",
"neodymium",
"neodymium",
"samarium",
"samarium",
"samarium",
"samarium",
"samarium",
"samarium",
"samarium",
"europium",
"europium",
"gadolinium",
"gadolinium",
"gadolinium",
"gadolinium",
"gadolinium",
"gadolinium",
"gadolinium",
"terbium",
"dysprosium",
"dysprosium",
"dysprosium",
"dysprosium",
"dysprosium",
"dysprosium",
"dysprosium",
"holmium",
"erbium",
"erbium",
"erbium",
"erbium",
"erbium",
"erbium",
"thulium",
"ytterbium",
"ytterbium",
"ytterbium",
"ytterbium",
"ytterbium",
"ytterbium",
"ytterbium",
"lutetium",
"lutetium",
"hafnium",
"hafnium",
"hafnium",
"hafnium",
"hafnium",
"hafnium",
"tantalum",
"tantalum",
"tungsten",
"tungsten",
"tungsten",
"tungsten",
"tungsten",
"rhenium",
"rhenium",
"osmium",
"osmium",
"osmium",
"osmium",
"osmium",
"osmium",
"osmium",
"iridium",
"iridium",
"platinum",
"platinum",
"platinum",
"platinum",
"platinum",
"platinum",
"gold",
"mercury",
"mercury",
"mercury",
"mercury",
"mercury",
"mercury",
"mercury",
"thallium",
"thallium",
"lead",
"lead",
"lead",
"lead",
"bismuth",
"uranium",
"uranium",
"uranium",
"thorium",
"protactinium",
};


const char* elem_table_symbol [NUMBER_OF_ISOTOPIC_ENTRIES] = {
"H",
"H",
"He",
"He",
"Li",
"Li",
"Be",
"B",
"B",
"C",
"C",
"N",
"N",
"O",
"O",
"O",
"F",
"Ne",
"Ne",
"Ne",
"Na",
"Mg",
"Mg",
"Mg",
"Al",
"Si",
"Si",
"Si",
"P",
"S",
"S",
"S",
"S",
"Cl",
"Cl",
"Ar",
"Ar",
"Ar",
"K",
"K",
"K",
"Ca",
"Ca",
"Ca",
"Ca",
"Ca",
"Ca",
"Sc",
"Ti",
"Ti",
"Ti",
"Ti",
"Ti",
"V",
"V",
"Cr",
"Cr",
"Cr",
"Cr",
"Mn",
"Fe",
"Fe",
"Fe",
"Fe",
"Co",
"Ni",
"Ni",
"Ni",
"Ni",
"Ni",
"Cu",
"Cu",
"Zn",
"Zn",
"Zn",
"Zn",
"Zn",
"Ga",
"Ga",
"Ge",
"Ge",
"Ge",
"Ge",
"Ge",
"As",
"Se",
"Se",
"Se",
"Se",
"Se",
"Se",
"Br",
"Br",
"Kr",
"Kr",
"Kr",
"Kr",
"Kr",
"Kr",
"Rb",
"Rb",
"Sr",
"Sr",
"Sr",
"Sr",
"Y",
"Zr",
"Zr",
"Zr",
"Zr",
"Zr",
"Nb",
"Mo",
"Mo",
"Mo",
"Mo",
"Mo",
"Mo",
"Mo",
"Ru",
"Ru",
"Ru",
"Ru",
"Ru",
"Ru",
"Ru",
"Rh",
"Pd",
"Pd",
"Pd",
"Pd",
"Pd",
"Pd",
"Ag",
"Ag",
"Cd",
"Cd",
"Cd",
"Cd",
"Cd",
"Cd",
"Cd",
"Cd",
"In",
"In",
"Sn",
"Sn",
"Sn",
"Sn",
"Sn",
"Sn",
"Sn",
"Sn",
"Sn",
"Sn",
"Sb",
"Sb",
"Te",
"Te",
"Te",
"Te",
"Te",
"Te",
"Te",
"Te",
"I",
"Xe",
"Xe",
"Xe",
"Xe",
"Xe",
"Xe",
"Xe",
"Xe",
"Xe",
"Cs",
"Ba",
"Ba",
"Ba",
"Ba",
"Ba",
"Ba",
"Ba",
"La",
"La",
"Ce",
"Ce",
"Ce",
"Ce",
"Pr",
"Nd",
"Nd",
"Nd",
"Nd",
"Nd",
"Nd",
"Nd",
"Sm",
"Sm",
"Sm",
"Sm",
"Sm",
"Sm",
"Sm",
"Eu",
"Eu",
"Gd",
"Gd",
"Gd",
"Gd",
"Gd",
"Gd",
"Gd",
"Tb",
"Dy",
"Dy",
"Dy",
"Dy",
"Dy",
"Dy",
"Dy",
"Ho",
"Er",
"Er",
"Er",
"Er",
"Er",
"Er",
"Tm",
"Yb",
"Yb",
"Yb",
"Yb",
"Yb",
"Yb",
"Yb",
"Lu",
"Lu",
"Hf",
"Hf",
"Hf",
"Hf",
"Hf",
"Hf",
"Ta",
"Ta",
"W",
"W",
"W",
"W",
"W",
"Re",
"Re",
"Os",
"Os",
"Os",
"Os",
"Os",
"Os",
"Os",
"Ir",
"Ir",
"Pt",
"Pt",
"Pt",
"Pt",
"Pt",
"Pt",
"Au",
"Hg",
"Hg",
"Hg",
"Hg",
"Hg",
"Hg",
"Hg",
"Tl",
"Tl",
"Pb",
"Pb",
"Pb",
"Pb",
"Bi",
"U",
"U",
"U",
"Th",
"Pa",
};


const bool elem_table_Radioactive [NUMBER_OF_ISOTOPIC_ENTRIES] = {
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
true,
false,
false,
false,
false,
false,
false,
true,
false,
false,
false,
false,
false,
false,
true,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
true,
false,
false,
false,
false,
false,
false,
true,
false,
false,
true,
false,
false,
false,
false,
false,
false,
true,
false,
false,
false,
false,
false,
false,
false,
false,
false,
true,
false,
false,
false,
false,
false,
false,
false,
true,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
true,
false,
true,
false,
true,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
true,
true,
false,
false,
false,
false,
false,
false,
false,
false,
false,
true,
false,
true,
false,
false,
false,
false,
false,
false,
true,
false,
false,
false,
false,
false,
false,
false,
false,
true,
false,
false,
false,
true,
false,
true,
true,
false,
false,
false,
false,
true,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
true,
true,
false,
false,
false,
false,
false,
true,
false,
true,
false,
false,
false,
false,
false,
true,
true,
true,
false,
false,
false,
false,
false,
false,
false,
true,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
false,
true,
true,
true,
true,
true,
true,
};


const double elem_table_probability [NUMBER_OF_ISOTOPIC_ENTRIES] = {
0.999884290164307909520857720053754746913909912109375000000000,
0.000115709835692033314582735648023970043141162022948265075684,
0.000001342999991941999914655050951672876635711872950196266174,
0.999998657000008006612290500925155356526374816894531250000000,
0.075933925285977116326208147256693337112665176391601562500000,
0.924066074714022800407065005856566131114959716796875000000000,
1.000000000000000000000000000000000000000000000000000000000000,
0.199480830670926506664741850727295968681573867797851562500000,
0.800519169329073410068531302385963499546051025390625000000000,
0.989211941850466902614869013632414862513542175292968750000000,
0.010788058149533083507343178553128382191061973571777343750000,
0.996358014567941707717579902237048372626304626464843750000000,
0.003641985432058271465738386041266494430601596832275390625000,
0.997567609729561044495937949250219389796257019042968750000000,
0.000380998476006095935803702490218825005285907536745071411133,
0.002051391794432822109073288885383590240962803363800048828125,
1.000000000000000000000000000000000000000000000000000000000000,
0.904766666333356561757739200402284041047096252441406250000000,
0.002709810313278070148523823945652111433446407318115234375000,
0.092523523353365264010328417043638182803988456726074218750000,
1.000000000000000000000000000000000000000000000000000000000000,
0.789876809855211581279377242026384919881820678710937500000000,
0.100001999840012789633192369365133345127105712890625000000000,
0.110121190304775615209642580794024979695677757263183593750000,
1.000000000000000000000000000000000000000000000000000000000000,
0.922220833349999713490774411184247583150863647460937500000000,
0.046858437698747611166449900110819726251065731048583984375000,
0.030920728951252581667707985957349592354148626327514648437500,
1.000000000000000000000000000000000000000000000000000000000000,
0.949850011999040066967836537514813244342803955078125000000000,
0.007519398448124149821059081233443066594190895557403564453125,
0.042520598352131823427502155254842364229261875152587890625000,
0.000109991200703943683199964587160479823069181293249130249023,
0.757594848103037898923162174469325691461563110351562500000000,
0.242405151896962045565686594272847287356853485107421875000000,
0.003336205796380696270847510120916012965608388185501098632812,
0.000629799206452999775149304007015871320618316531181335449219,
0.996033994997166272078459314798237755894660949707031250000000,
0.932580526071084436878777523816097527742385864257812500000000,
0.000117099885242112454345267402722186034225160256028175354004,
0.067302374043673424131029037198459263890981674194335937500000,
0.969400838426726974006442105746828019618988037109375000000000,
0.006472228417153705684605746739634923869743943214416503906250,
0.001350985058105257227353823701321289263432845473289489746094,
0.020860869278785776348428271376178599894046783447265625000000,
0.000042999524425259849917842214228613784143817611038684844971,
0.001872079294802999303859447621789513505063951015472412109375,
1.000000000000000000000000000000000000000000000000000000000000,
0.082520097588289403889305617667559999972581863403320312500000,
0.074411070671519405350657905273692449554800987243652343750000,
0.737141543014838140912559083517407998442649841308593750000000,
0.054113506379234489751528514034362160600721836090087890625000,
0.051813782346118462951434224805780104361474514007568359375000,
0.002503979968160254584302881752932989911641925573348999023438,
0.997496020031839680797247638111002743244171142578125000000000,
0.043450743830478963380947732275672024115920066833496093750000,
0.837881075122238416774678171350387856364250183105468750000000,
0.095010483865806516501351097758742980659008026123046875000000,
0.023657697181476075587447382986283628270030021667480468750000,
1.000000000000000000000000000000000000000000000000000000000000,
0.058452792721208068904559240763774141669273376464843750000000,
0.917532497856775930422656983864726498723030090332031250000000,
0.021190743592002535267138085828264593146741390228271484375000,
0.002823965830013456732028309659199294401332736015319824218750,
1.000000000000000000000000000000000000000000000000000000000000,
0.680769095231327558970235713786678388714790344238281250000000,
0.262230419610671172669924544607056304812431335449218750000000,
0.011399083035777891892426083586542517878115177154541015625000,
0.036346250253448952882706635136855766177177429199218750000000,
0.009255151868774300419340228529563319170847535133361816406250,
0.691494255172344751692037334578344598412513732910156250000000,
0.308505744827655137285660202906001359224319458007812500000000,
0.491645713885820234700929631799226626753807067871093750000000,
0.277325508740183801492662496457342058420181274414062500000000,
0.040405292597461665848879164286699960939586162567138671875000,
0.184515103497573135227227680843498092144727706909179687500000,
0.006108381278961075126765489784474993939511477947235107421875,
0.601079797840404217446064194518839940428733825683593750000000,
0.398920202159595671531633342965506017208099365234375000000000,
0.205705812301332946478993335404084064066410064697265625000000,
0.274503726116209989527305879164487123489379882812500000000000,
0.077504017086240106770844704442424699664115905761718750000000,
0.364982406812098314485837136089685373008251190185546875000000,
0.077304037684118531714716482383664697408676147460937500000000,
1.000000000000000000000000000000000000000000000000000000000000,
0.008938426836876709608015190156038443092256784439086914062500,
0.093712506598838590798905556766840163618326187133789062500000,
0.076302570747548426055573145276866853237152099609375000000000,
0.237686167234566703143627819372341036796569824218750000000000,
0.496053694549759227605534306348999962210655212402343750000000,
0.087306634032410290746639702774700708687305450439453125000000,
0.506898896176611657438115798868238925933837890625000000000000,
0.493101103823388231539581738616107031702995300292968750000000,
0.003552948126957346328819165037771199422422796487808227539062,
0.022860666234272977725971998097520554438233375549316406250000,
0.115931407401451927463575941601447993889451026916503906250000,
0.115000220996773441783922464765055337920784950256347656250000,
0.569863179997571966950431487930472940206527709960937500000000,
0.172791577242972227423933873069472610950469970703125000000000,
0.721691132354705722207199869444593787193298339843750000000000,
0.278308867645294166770497668039752170443534851074218750000000,
0.005609775608975640752429381308274969342164695262908935546875,
0.098606055757769678349333730693615507334470748901367187500000,
0.070007199712011511372189431767765199765563011169433593750000,
0.825776968921243081922511919401586055755615234375000000000000,
1.000000000000000000000000000000000000000000000000000000000000,
0.514422711621750239352479638910153880715370178222656250000000,
0.112234410554393593262290096390643157064914703369140625000000,
0.171550886397901253266340404479706194251775741577148437500000,
0.173788376250214926521664438041625544428825378417968750000000,
0.028003615175739928616627238966430013533681631088256835937500,
1.000000000000000000000000000000000000000000000000000000000000,
0.145308494342837241086741073559096548706293106079101562500000,
0.091496458524138415957516201615362660959362983703613281250000,
0.158387558641321063435114524509117472916841506958007812500000,
0.166690329831184980147185115129104815423488616943359375000000,
0.095999792030779435014764544575882609933614730834960937500000,
0.243900902666405350327494261364336125552654266357421875000000,
0.098216463963333416886669624545902479439973831176757812500000,
0.055402974808013198682044020415560225956141948699951171875000,
0.018726273471579152340993346115283202379941940307617187500000,
0.127588609866636532030881312493875157088041305541992187500000,
0.126054915071900669465421174209041055291891098022460937500000,
0.170586053375378299268305681835045106709003448486328125000000,
0.315451225206183960558803391904802992939949035644531250000000,
0.186189948200308125203505937861336860805749893188476562500000,
1.000000000000000000000000000000000000000000000000000000000000,
0.010207550187954890497099569302008603699505329132080078125000,
0.111463248820283120088525663504697149619460105895996093750000,
0.223336399264176588275176982278935611248016357421875000000000,
0.273264416540030363744762098576757125556468963623046875000000,
0.264546508837878890929573572066146880388259887695312500000000,
0.117181876349676070137029171291942475363612174987792968750000,
0.518389668985958174118877650471404194831848144531250000000000,
0.481610331014041714858819887012941762804985046386718750000000,
0.012567197514954164816458614950533956289291381835937500000000,
0.008928009053980960965657409644791187020018696784973144531250,
0.124890149496662231087817929164884844794869422912597656250000,
0.127983459688489453753845737082883715629577636718750000000000,
0.241267197414976458658131264201074372977018356323242187500000,
0.122184752800125570604272695618419675156474113464355468750000,
0.287277937020044504823346187549759633839130401611328125000000,
0.074901297010766587636254598692175932228565216064453125000000,
0.042954845418549769675564675708301365375518798828125000000000,
0.957045154581450119302132861776044592261314392089843750000000,
0.009707379007667929146641050408561568474397063255310058593750,
0.006608215781738930282018795736576066701672971248626708984375,
0.003409079548521898664348306340343697229400277137756347656250,
0.145370749897527656857576516813423950225114822387695312500000,
0.076859248003039171148742525474517606198787689208984375000000,
0.242144620952342848330118840749491937458515167236328125000000,
0.085916802463334898676272644024720648303627967834472656250000,
0.325722055045137792728127124064485542476177215576171875000000,
0.046317494276545329023875297025369945913553237915039062500000,
0.057944355024143474885978122301821713335812091827392578125000,
0.572091349038115315472907695948379114270210266113281250000000,
0.427908650961884573504789841535966843366622924804687500000000,
0.000909764371027903685079651907585684966761618852615356445312,
0.025505394102927340937991829150632838718593120574951171875000,
0.008927687728878220055350745099076448241248726844787597656250,
0.047401722953754971134898710261040832847356796264648437500000,
0.070696689557404629455916733604681212455034255981445312500000,
0.188376210561464557668998054396070074290037155151367187500000,
0.317407791382032011817670991149498149752616882324218750000000,
0.340774739342510235573513455165084451436996459960937500000000,
1.000000000000000000000000000000000000000000000000000000000000,
0.000952296533640617525774685336870106766582466661930084228516,
0.000890196759683794711613680217254795934422872960567474365234,
0.019102830465697103606848017420816177036613225936889648437500,
0.264005869018636762923790683998959138989448547363281250000000,
0.040709981815666186621971434078659513033926486968994140625000,
0.212323527142361190289676642350968904793262481689453125000000,
0.269085350529324029977829013660084456205368041992187500000000,
0.104356830141138279266499466757522895932197570800781250000000,
0.088573117593851946605099101361702196300029754638671875000000,
1.000000000000000000000000000000000000000000000000000000000000,
0.001060985146207953045902061539607075246749445796012878417969,
0.001010985846198153050023993415607037604786455631256103515625,
0.024171461599537605313692267827718751505017280578613281250000,
0.065920277116120362670415033790050074458122253417968750000000,
0.078541300421794094099858796198532218113541603088378906250000,
0.112320827508414877726750091824214905500411987304687500000000,
0.716974162361726841119491382414707913994789123535156250000000,
0.000888171872103250392010975744483403104823082685470581054688,
0.999111828127896672846475212281802669167518615722656250000000,
0.001851973331584025024912354417949700291501358151435852050781,
0.002511963827720880421123794690174690913408994674682617187500,
0.884492463308528265031327464384958148002624511718750000000000,
0.111143599532166723053983048430382041260600090026855468750000,
1.000000000000000000000000000000000000000000000000000000000000,
0.271519166958828106483991859931848011910915374755859375000000,
0.121740433020292235233306143982190405949950218200683593750000,
0.237977663997580829446931716120161581784486770629882812500000,
0.082929723850915446070608538775559281930327415466308593750000,
0.171890140355501652713599014532519504427909851074218750000000,
0.057561075412857647115583148433870519511401653289794921875000,
0.056381796404024006608146635244338540360331535339355468750000,
0.030772522277086666181444840617587033193558454513549804687500,
0.149881578776357327065227309503825381398200988769531250000000,
0.112382691006085513873991033051424892619252204895019531250000,
0.138246406123312015612469849656918086111545562744140625000000,
0.073792068527347848272412988990254234522581100463867187500000,
0.267451009404714612482933944193064235150814056396484375000000,
0.227473723885095902019770619517657905817031860351562500000000,
0.478103065570820051632949798658955842256546020507812500000000,
0.521896934429179837344747738825390115380287170410156250000000,
0.002009636255837693018938550082452820788603276014328002929688,
0.021826049485043207132317633067941642366349697113037109375000,
0.147985214676143617129611129712429828941822052001953125000000,
0.204672954195290635048820604424690827727317810058593750000000,
0.156491675006823760529783839956508018076419830322265625000000,
0.248435033258980114689862261911912355571985244750976562500000,
0.218579437121880937322515592313720844686031341552734375000000,
1.000000000000000000000000000000000000000000000000000000000000,
0.000562985756460361477619691594753703611786477267742156982422,
0.000952975889709990254573812595850768047966994345188140869141,
0.023291210732368467645203580218549177516251802444458007812500,
0.188889421097646226233024435714469291269779205322265625000000,
0.254747154896981076177553404704667627811431884765625000000000,
0.248957901365095435330943018925609067082405090332031250000000,
0.282598350261738351374418698469526134431362152099609375000000,
1.000000000000000000000000000000000000000000000000000000000000,
0.001395973476503946332158423437874716910300776362419128417969,
0.016012695758780580435054474719436257146298885345458984375000,
0.335027234482544788995994622382568195462226867675781250000000,
0.228686654953555862368475004586798604577779769897460937500000,
0.269776674243189351631855288360384292900562286376953125000000,
0.149100767085425356395234075534972362220287322998046875000000,
1.000000000000000000000000000000000000000000000000000000000000,
0.001232929969577727796758992440118163358420133590698242187500,
0.029822206098693591902470956256365752778947353363037109375000,
0.140905996539396560773838018576498143374919891357421875000000,
0.216800685721051017429417129278590437024831771850585937500000,
0.161027253651992552363481081556528806686401367187500000000000,
0.320249909805123023076589561242144554853439331054687500000000,
0.129961018214165419104588750087714288383722305297851562500000,
0.974008767577204226384424146090168505907058715820312500000000,
0.025991232422795697287742910930319339968264102935791015625000,
0.001609652315099938373749166586890169128309935331344604492188,
0.052668623577307296934613134453684324398636817932128906250000,
0.185969830516608397585898160286888014525175094604492187500000,
0.272821070648739838482299546740250661969184875488281250000000,
0.136190582834107815068946933934057597070932388305664062500000,
0.350740240108136591690168870627530850470066070556640625000000,
0.000120131992311552486551486096377772128107608295977115631104,
0.999879868007688354936135510797612369060516357421875000000000,
0.001209872963338849303702171589236513682408258318901062011719,
0.264988176241494621798722164385253563523292541503906250000000,
0.143124971877952811283307710255030542612075805664062500000000,
0.306387829277925793913794905165559612214565277099609375000000,
0.284289149639287863635672692907974123954772949218750000000000,
0.374005039798408045470523575204424560070037841796875000000000,
0.625994960201591843507173962279921397566795349121093750000000,
0.000209947723016968765524098428087995671376120299100875854492,
0.015926034417430057904541129687459033448249101638793945312500,
0.019615115836156795520173190539026109036058187484741210937500,
0.132457018202467580181291850749403238296508789062500000000000,
0.161519781574387955025429164379602298140525817871093750000000,
0.262554623898649197588639481182326562702655792236328125000000,
0.407717478347891348899878494194126687943935394287109375000000,
0.373050779688124722888176165724871680140495300292968750000000,
0.626949220311875166089521371759474277496337890625000000000000,
0.000121987349911814132899338936066868654961581341922283172607,
0.007821588901230941415221309398475568741559982299804687500000,
0.328605923565726210089366077227168716490268707275390625000000,
0.337788971283677852408544595164130441844463348388671875000000,
0.252107856415289710572125159160350449383258819580078125000000,
0.073553672484163390432598816914833150804042816162109375000000,
1.000000000000000000000000000000000000000000000000000000000000,
0.001509815802472098391837085351596670079743489623069763183594,
0.099707835644051417967048678292485419660806655883789062500000,
0.168701418426951910145561441822792403399944305419921875000000,
0.230990819120067331082779560347262304276227951049804687500000,
0.131793921141620695713925215386552736163139343261718750000000,
0.298589572072207154462830658303573727607727050781250000000000,
0.068706617792629293139938795320631470531225204467773437500000,
0.295204095918081610427918803907232359051704406738281250000000,
0.704795904081918278549778733577113598585128784179687500000000,
0.014094362255097959285565778486670751590281724929809570312500,
0.241003598560575765796798464180028531700372695922851562500000,
0.221011595361855245345239495691203046590089797973632812500000,
0.523890443822470963652904174523428082466125488281250000000000,
1.000000000000000000000000000000000000000000000000000000000000,
0.000054599923560107009460132254652364736102754250168800354004,
0.007204689913434121108226637630878030904568731784820556640625,
0.992740710163005690702675565262325108051300048828125000000000,
1.000000000000000000000000000000000000000000000000000000000000,
1.000000000000000000000000000000000000000000000000000000000000,
};


const double elem_table_log_probability [NUMBER_OF_ISOTOPIC_ENTRIES] = {
-0.000115716530591520062594239337538937206772970966994762420654,
-9.064424917075021070900220365729182958602905273437500000000000,
-13.520604646423175054792409355286508798599243164062500000000000,
-0.000001343000893767296712052561162564767727189973811618983746,
-2.577891720978651601825504258158616721630096435546875000000000,
-0.078971700466369670889932308455172460526227951049804687500000,
0.000000000000000000000000000000000000000000000000000000000000,
-1.612037134131381055368592569720931351184844970703125000000000,
-0.222494800137427506392384657374350354075431823730468750000000,
-0.010846671177187771836769591971005866071209311485290527343750,
-4.529315483514038120915756735485047101974487304687500000000000,
-0.003648633607616148452623683340334537206217646598815917968750,
-5.615226297668721500144783931318670511245727539062500000000000,
-0.002435353337518350851781390176142849668394774198532104492188,
-7.872715182829573166145564755424857139587402343750000000000000,
-6.189236792082963845018639403861016035079956054687500000000000,
0.000000000000000000000000000000000000000000000000000000000000,
-0.100078195781331494296217954342864686623215675354003906250000,
-5.910876641640641970809610938886180520057678222656250000000000,
-2.380292360271312634978357891668565571308135986328125000000000,
0.000000000000000000000000000000000000000000000000000000000000,
-0.235878282572628383828572395941591821610927581787109375000000,
-2.302565094793883382351395994191989302635192871093750000000000,
-2.206173789605455404227996041299775242805480957031250000000000,
0.000000000000000000000000000000000000000000000000000000000000,
-0.080970568540825488268453113960276823490858078002929687500000,
-3.060624186220378017964094397029839456081390380859375000000000,
-3.476328480144544208485513081541284918785095214843750000000000,
0.000000000000000000000000000000000000000000000000000000000000,
-0.051451188958515865767839869704403099603950977325439453125000,
-4.890269137820559386398144852137193083763122558593750000000000,
-3.157766653355948971437783256988041102886199951171875000000000,
-9.115110188972028737453001667745411396026611328125000000000000,
-0.277606537419771426389303314863354898989200592041015625000000,
-1.417144771312495832304989562544506043195724487304687500000000,
-5.702921106825801444983881083317101001739501953125000000000000,
-7.370109509296556282720302988309413194656372070312500000000000,
-0.003973890456746663815690290277871099533513188362121582031250,
-0.069799776156532433724066777358530089259147644042968750000000,
-9.052483267360123875278077321127057075500488281250000000000000,
-2.698559767416127019856730839819647371768951416015625000000000,
-0.031077090678799931117159971449837030377238988876342773437500,
-5.040234806716209270405215647770091891288757324218750000000000,
-6.606921279942914004834619845496490597724914550781250000000000,
-3.869880158236262079896050636307336390018463134765625000000000,
-10.054321502209552008366699737962335348129272460937500000000000,
-6.280705543488890540970714937429875135421752929687500000000000,
0.000000000000000000000000000000000000000000000000000000000000,
-2.494713408178120150893164463923312723636627197265625000000000,
-2.598150548864236686341655513388104736804962158203125000000000,
-0.304975352295239643396485007542651146650314331054687500000000,
-2.916671468480125817279713373864069581031799316406250000000000,
-2.960099096648749483762230738648213446140289306640625000000000,
-5.989873825712285437816717603709548711776733398437500000000000,
-0.002507120169096173530054461053850900498218834400177001953125,
-3.136127308188753737283605005359277129173278808593750000000000,
-0.176879103699552453488053060937090776860713958740234375000000,
-2.353768036988251211028000398073345422744750976562500000000000,
-3.744066754776672834026385316974483430385589599609375000000000,
0.000000000000000000000000000000000000000000000000000000000000,
-2.839535812544084603104010966490022838115692138671875000000000,
-0.086067279673300162157190129619266372174024581909179687500000,
-3.854190815670504033363386042765341699123382568359375000000000,
-5.869613059277937416879922238877043128013610839843750000000000,
0.000000000000000000000000000000000000000000000000000000000000,
-0.384532097536943340276849312431295402348041534423828125000000,
-1.338531697560186861650777245813515037298202514648437500000000,
-4.474222362274872466514352709054946899414062500000000000000000,
-3.314664237037550087450199498562142252922058105468750000000000,
-4.682574923715371539856278104707598686218261718750000000000000,
-0.368900435688631012087768112905905582010746002197265625000000,
-1.176014814002444008878001113771460950374603271484375000000000,
-0.709996915609857004447746930964058265089988708496093750000000,
-1.282563340904273152531800405995454639196395874023437500000000,
-3.208794497707758708315850526560097932815551757812500000000000,
-1.690023957076583371872402494773268699645996093750000000000000,
-5.098093470692335316130083811003714799880981445312500000000000,
-0.509027578151938331352255318051902577280998229980468750000000,
-0.918993876681337473755206701753195375204086303710937500000000,
-1.581308226517597503857359697576612234115600585937500000000000,
-1.292790443930836863373201595095451921224594116210937500000000,
-2.557425510595298323579527277615852653980255126953125000000000,
-1.007906127076126923114429700945038348436355590820312500000000,
-2.560009090805706488680471011321060359477996826171875000000000,
0.000000000000000000000000000000000000000000000000000000000000,
-4.717395674310531639150667615467682480812072753906250000000000,
-2.367523623737181281967423274181783199310302734375000000000000,
-2.573048648630889889687978211441077291965484619140625000000000,
-1.436804100526558380934716296906117349863052368164062500000000,
-0.701071102975730831019518518587574362754821777343750000000000,
-2.438328827816317101451204507611691951751708984375000000000000,
-0.679443711102156733261381305055692791938781738281250000000000,
-0.707041047215952844773312335746595636010169982910156250000000,
-5.639977561836668762396129750413820147514343261718750000000000,
-3.778337476933724126126890041632577776908874511718750000000000,
-2.154756578276459499932116159470751881599426269531250000000000,
-2.162821228909660220551813836209475994110107421875000000000000,
-0.562358982058553724669991424889303743839263916015625000000000,
-1.755669166607024767046141278115101158618927001953125000000000,
-0.326158026142060741836559145667706616222858428955078125000000,
-1.279023747338471794776637580071110278367996215820312500000000,
-5.183244558647554178776317712618038058280944824218750000000000,
-2.316622601837921013867571673472411930561065673828125000000000,
-2.659157189193052328590738397906534373760223388671875000000000,
-0.191430555333882340685036638205929193645715713500976562500000,
0.000000000000000000000000000000000000000000000000000000000000,
-0.664709955358130821778672725486103445291519165039062500000000,
-2.187165643480033949686003325041383504867553710937500000000000,
-1.762875342696557545707491954090073704719543457031250000000000,
-1.749916948420700224531287858553696423768997192382812500000000,
-3.575421663722070153568211026140488684177398681640625000000000,
0.000000000000000000000000000000000000000000000000000000000000,
-1.928896249393138528915869756019674241542816162109375000000000,
-2.391455012103930855005273770075291395187377929687500000000000,
-1.842710346617601580021528206998482346534729003906250000000000,
-1.791617500319007794118419951701071113348007202148437500000000,
-2.343409253862695162951013116980902850627899169921875000000000,
-1.410993272797839370724659602274186909198760986328125000000000,
-2.320581420206905942649200369487516582012176513671875000000000,
-2.893121989774980473697496563545428216457366943359375000000000,
-3.977827742728266446903262476553209125995635986328125000000000,
-2.058944176423800787034679160569794476032257080078125000000000,
-2.071037633074694905843671222100965678691864013671875000000000,
-1.768515397703714908672623096208553761243820190429687500000000,
-1.153751204177984268639534093381371349096298217773437500000000,
-1.680987899482990099997437027923297137022018432617187500000000,
0.000000000000000000000000000000000000000000000000000000000000,
-4.584627618010170380102863418869674205780029296875000000000000,
-2.194060349407264354226754221599549055099487304687500000000000,
-1.499076127310911887846600620832759886980056762695312500000000,
-1.297315393792867643796284937707241624593734741210937500000000,
-1.329738206325086657955125701846554875373840332031250000000000,
-2.144028052451655508292560625704936683177947998046875000000000,
-0.657028062796280343249577526876237243413925170898437500000000,
-0.730619933776488150733996462804498150944709777832031250000000,
-4.376665231519177190477876138174906373023986816406250000000000,
-4.718561859232925925766721775289624929428100585937500000000000,
-2.080320732081178736194715384044684469699859619140625000000000,
-2.055854244595972435405428768717683851718902587890625000000000,
-1.421850256682005708697147383645642548799514770507812500000000,
-2.102221012532442756537420791573822498321533203125000000000000,
-1.247305110167633124262920318869873881340026855468750000000000,
-2.591584072043251474326552852289751172065734863281250000000000,
-3.147605821582104113076638896018266677856445312500000000000000,
-0.043904705171597842305875047941299271769821643829345703125000,
-4.634868960235463575259018398355692625045776367187500000000000,
-5.019441588675102039474040793720632791519165039062500000000000,
-5.681312951243271847090454684803262352943420410156250000000000,
-1.928467904013302591792466955666895955801010131835937500000000,
-2.565779477876660052970692049711942672729492187500000000000000,
-1.418220124080461719273671405971981585025787353515625000000000,
-2.454375864191848055639866288402117788791656494140625000000000,
-1.121710853164690879779641363711562007665634155273437500000000,
-3.072235543110140021383358543971553444862365722656250000000000,
-2.848272125086215300626690805074758827686309814453125000000000,
-0.558456599237618478426270485215354710817337036132812500000000,
-0.848845538512307262735134827380534261465072631835937500000000,
-7.002324924918669424300787795800715684890747070312500000000000,
-3.668865315739671117967191094066947698593139648437500000000000,
-4.718597850559019590832576795946806669235229492187500000000000,
-3.049096701706386802754877862753346562385559082031250000000000,
-2.649356530974964485380951373372226953506469726562500000000000,
-1.669314195717893856141245123581029474735260009765625000000000,
-1.147567923673684653351756423944607377052307128906250000000000,
-1.076533608421685217493291020218748599290847778320312500000000,
0.000000000000000000000000000000000000000000000000000000000000,
-6.956634086757649271248737932182848453521728515625000000000000,
-7.024068041375896243039278488140553236007690429687500000000000,
-3.957918762987576943856993239023722708225250244140625000000000,
-1.331783944951729026229259034153074026107788085937500000000000,
-3.201281963147128539759478371706791222095489501953125000000000,
-1.549644096147559713116947932576294988393783569335937500000000,
-1.312726661492457758129148714942857623100280761718750000000000,
-2.259939193445343441624117986066266894340515136718750000000000,
-2.423926880572130126978436237550340592861175537109375000000000,
0.000000000000000000000000000000000000000000000000000000000000,
-6.848557419252292000066972832428291440010070800781250000000000,
-6.896829338845804180380127945682033896446228027343750000000000,
-3.722582614455130833874818563344888389110565185546875000000000,
-2.719309189565115580933252203976735472679138183593750000000000,
-2.544130672523534641982223547529429197311401367187500000000000,
-2.186395971313551900294669394497759640216827392578125000000000,
-0.332715474789523235621402363904053345322608947753906250000000,
-7.026345284034602123313106858404353260993957519531250000000000,
-0.000888566530440708531556059934786162557429634034633636474609,
-6.291503542654471203832144965417683124542236328125000000000000,
-5.986690430272505913933400734094902873039245605468750000000000,
-0.122741286268200244791160002932883799076080322265625000000000,
-2.196932224286036738902794240857474505901336669921875000000000,
0.000000000000000000000000000000000000000000000000000000000000,
-1.303722545566528001614869936020113527774810791015625000000000,
-2.105864098995690714133388610207475721836090087890625000000000,
-1.435578458464392248572494281688705086708068847656250000000000,
-2.489761730430327446583760320208966732025146484375000000000000,
-1.760899725099839052688821539049968123435974121093750000000000,
-2.854908713800850428299327177228406071662902832031250000000000,
-2.875608931369854293080834395368583500385284423828125000000000,
-3.481133121051686263314195457496680319309234619140625000000000,
-1.897909771509530774125096286297775804996490478515625000000000,
-2.185845347988713882614320027641952037811279296875000000000000,
-1.978717634408995396100294783536810427904129028320312500000000,
-2.606504025680458358493751802598126232624053955078125000000000,
-1.318818871830977013104302386636845767498016357421875000000000,
-1.480720546667873893653677441761828958988189697265625000000000,
-0.737928951383980402667361886415164917707443237304687500000000,
-0.650285154216317162756411107693566009402275085449218750000000,
-6.209801540532629005042508651968091726303100585937500000000000,
-3.824651092041761124562526674708351492881774902343750000000000,
-1.910642911045310476936265331460162997245788574218750000000000,
-1.586341919151083468264573639316949993371963500976562500000000,
-1.854752465261401805918239915627054870128631591796875000000000,
-1.392573903203236485026650370855350047349929809570312500000000,
-1.520605773895307155640921337180770933628082275390625000000000,
0.000000000000000000000000000000000000000000000000000000000000,
-7.482256229504544720043668348807841539382934570312500000000000,
-6.955920953990032629121742502320557832717895507812500000000000,
-3.759679211363279094371137034613639116287231445312500000000000,
-1.666593508702244319508167791354935616254806518554687500000000,
-1.367483775157640080166743246081750839948654174804687500000000,
-1.390471467634422086945278351777233183383941650390625000000000,
-1.263728646463758931162146836868487298488616943359375000000000,
0.000000000000000000000000000000000000000000000000000000000000,
-6.574163274461459316455602674977853894233703613281250000000000,
-4.134373386461300370342542009893804788589477539062500000000000,
-1.093543453498669215662175702163949608802795410156250000000000,
-1.475402531411262208038692733680363744497299194335937500000000,
-1.310160794679168905219057705835439264774322509765625000000000,
-1.903132912453214142800561603507958352565765380859375000000000,
0.000000000000000000000000000000000000000000000000000000000000,
-6.698361853186871606169461301760748028755187988281250000000000,
-3.512501991875810691823289744206704199314117431640625000000000,
-1.959662302151332857746979243529494851827621459960937500000000,
-1.528776846501670894085123109107371419668197631835937500000000,
-1.826181650981897996999236966075841337442398071289062500000000,
-1.138653619844293141127877788676414638757705688476562500000000,
-2.040520733384556528733355662552639842033386230468750000000000,
-0.026334973760810023724054929061821894720196723937988281250000,
-3.649996012338110329409346377360634505748748779296875000000000,
-6.431737076661124596910212858347222208976745605468750000000000,
-2.943735378782415867959798561059869825839996337890625000000000,
-1.682170819948636486529380817955825477838516235351562500000000,
-1.298939117547105670524842935265041887760162353515625000000000,
-1.993700029844323484695678416755981743335723876953125000000000,
-1.047709386165366352017258577689062803983688354492187500000000,
-9.026919483738925720217594061978161334991455078125000000000000,
-0.000120139208737295727770326425609681564310449175536632537842,
-6.717239913861373423742406885139644145965576171875000000000000,
-1.328070071947949681856471215724013745784759521484375000000000,
-1.944037101159571623298916165367700159549713134765625000000000,
-1.182903563582415440436079734354279935359954833984375000000000,
-1.257763426233626136152565777592826634645462036132812500000000,
-0.983486006261584555510069094452774152159690856933593750000000,
-0.468412958710625382252601411892101168632507324218750000000000,
-8.468651996251450597696930344682186841964721679687500000000000,
-4.139800124064825226355424092616885900497436523437500000000000,
-3.931454793849565199082007893593981862068176269531250000000000,
-2.021497077106750417385683249449357390403747558593750000000000,
-1.823127657291570224984411652258131653070449829101562500000000,
-1.337296127555923419549799291417002677917480468750000000000000,
-0.897180799465370992784585268964292481541633605957031250000000,
-0.986040730030275258677363581227837130427360534667968750000000,
-0.466889729967265909582607719130464829504489898681640625000000,
-9.011593207854545539703394751995801925659179687500000000000000,
-4.850867560763419739089385984698310494422912597656250000000000,
-1.112896046865470500719652591214980930089950561523437500000000,
-1.085333923798379451852724741911515593528747558593750000000000,
-1.377898281389317913792069703049492090940475463867187500000000,
-2.609739901377524873282709449995309114456176757812500000000000,
0.000000000000000000000000000000000000000000000000000000000000,
-6.495767620713909451524159521795809268951416015625000000000000,
-2.305511012885385291326656442834064364433288574218750000000000,
-1.779624881481258524829058842442464083433151245117187500000000,
-1.465377313319132568381064629647880792617797851562500000000000,
-2.026515779816368212351562760886736214160919189453125000000000,
-1.208685317218918919834891312348190695047378540039062500000000,
-2.677909755533927516069070406956598162651062011718750000000000,
-1.220088311290825400234894004825036972761154174804687500000000,
-0.349847015838577246604756965098204091191291809082031250000000,
-4.261980401619341662922124669421464204788208007812500000000000,
-1.422943413816338820154783206817228347063064575195312500000000,
-1.509540111140063478600836788245942443609237670898437500000000,
-0.646472693195343506289418655796907842159271240234375000000000,
0.000000000000000000000000000000000000000000000000000000000000,
-9.815478075212435982166425674222409725189208984375000000000000,
-4.933023088148108747930109529988840222358703613281250000000000,
-0.007285766694735069763655399555091207730583846569061279296875,
0.000000000000000000000000000000000000000000000000000000000000,
0.000000000000000000000000000000000000000000000000000000000000,
};

#ifdef __cplusplus
}
#endif


