% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InterVA5.plot.R
\name{CSMF.interVA5}
\alias{CSMF.interVA5}
\title{Summarize population level cause-specific mortality fraction as InterVA5 suggested.}
\usage{
CSMF.interVA5(va)
}
\arguments{
\item{va}{The list of va object to summarize.}
}
\value{
\item{dist.cod}{The cause-specific mortality fraction (including undetermined category).}
}
\description{
The function takes input of a list of va object and calculates the
cause-specific mortality fraction. It only calculates CSMF5 as aggregation of up to the third largest causes.
}
\examples{

data(SampleInputV5)
sample.output <- InterVA5(SampleInputV5, HIV = "h", Malaria = "v", write=TRUE,
       directory = tempdir(), filename = "VA5_result", output = "extended", append = FALSE)
## Get CSMF without plots
csmf <- CSMF.interVA5(sample.output$VA5)


}
\seealso{
\code{\link{CSMF5}}
}
\author{
Jason Thomas, Zehang LI, Tyler McCormick, Sam Clark
}
\keyword{interVA}
