% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/InterVA.plot.R
\name{CSMF.interVA4}
\alias{CSMF.interVA4}
\title{Summarize population level cause-specific mortality fraction as InterVA4 suggested.}
\usage{
CSMF.interVA4(va)
}
\arguments{
\item{va}{The list of va object to summarize.}
}
\value{
\item{dist.cod}{The cause-specific mortality fraction (including undetermined category).}
}
\description{
The function takes input of a list of va object and calculates the
cause-specific mortality fraction. It only calculates CSMF as aggregation of up to the third largest causes.
}
\examples{
data(SampleInput)
sample.output <- InterVA(SampleInput, HIV = "h", Malaria = "v", directory = "VA test",
       filename = "VA_result", output = "extended", append = FALSE)
## Get CSMF without plots
csmf<- CSMF.interVA4(sample.output$VA)
data(SampleInput)
}
\author{
Zehang LI, Tyler McCormick, Sam Clark
}
\seealso{
\code{\link{CSMF}}
}
\keyword{interVA}

