% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Functions.R
\name{volcano}
\alias{volcano}
\title{volcano}
\usage{
volcano(x, pValue, pointLabels, topPValues = 10, topXvalues = 10,
  smoothScatter = TRUE, xlab = NULL, ylab = NULL, main = NULL,
  newpage = TRUE, additionalPointsToLabel = NULL,
  additionalLabelColor = "red", dir = TRUE)
}
\arguments{
\item{x}{Numeric vector of logratios or covariate effect values to be plotted.}

\item{pValue}{Numeric vector of corresponding p-values obtained from some statistical test.}

\item{pointLabels}{Character vector providing the texts for the points to be labelled in the plot.}

\item{topPValues}{Number of top p-values to be labelled. Default value is 10.}

\item{topXvalues}{Number of top logratios or covariate effect values to be labelled. Default value is 10.}

\item{smoothScatter}{Logical parameter to decide if a smooth plot is expected or not. Default is TRUE.}

\item{xlab}{Text for the x-axis of the plot. Default is NULL.}

\item{ylab}{Text for the y-axis of the plot. Default is NULL.}

\item{main}{Text for the main title of the plot. Default is NULL.}

\item{newpage}{Logical parameter}

\item{additionalPointsToLabel}{Set of points other than the top values to be labelled in the plot. Default is NULL.}

\item{additionalLabelColor}{Colour of the additionally labelled points. Default colour is red.}

\item{dir}{Logical parameter deciding if the top values should be in decreasing (= TRUE) or increasing (= FALSE) order. Default is TRUE.}
}
\value{
A plot which looks like a volcano.
}
\description{
The volcano function produces the volcano plot for logratio / fp-effect vs corresponding p-values.
}
\details{
Creates a plot which looks like a volcano with the interesting points labelled within the plot.
}
\examples{
\dontrun{
volcano(x=jmRes$CovEffect1,pValue=jmRes$rawP1,pointLabels=rownames(jmRes),
topPValues = 10, topXvalues = 10,xlab="FP Effect (alpha)",ylab="-log(p-values)")
}
}

