% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supportingfunctions.R
\name{InteRD.predict.prop}
\alias{InteRD.predict.prop}
\title{Extract the estimated proportions from InteRD}
\usage{
InteRD.predict.prop(InteRD.output)
}
\arguments{
\item{InteRD.output}{An object from InteRD1 or InteRD2.}
}
\value{
Estimated cell type proportions from InteRD.
}
\description{
This function extract estimated cell type proportions via InteRD1 and InteRD2.
}
\examples{
##read data
library(InteRD)
readRDSFromWeb<-function(ref) {readRDS(gzcon(url(ref)))}
urlremote<-"https://github.com/chencxxy28/Data/raw/main/data_InteRD/"
InteRD1.output<-readRDSFromWeb(paste0(urlremote,"InteRD1.output.rds"))
lambda_option<-0
cell_type_unique<-c("alpha","beta","delta","gamma")
InteRD1<-InteRD.predict.prop(InteRD.output=InteRD1.output)

}
