% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mission_orbits.R
\name{available_nominal_orbits}
\alias{available_nominal_orbits}
\title{Nominal mission orbits}
\usage{
available_nominal_orbits(
  orbit_area = NULL,
  technical_specs_url = "https://icesat-2.gsfc.nasa.gov/science/specs",
  verbose = FALSE
)
}
\arguments{
\item{orbit_area}{either NULL or a character string specifying the earth partition to use, it can be one of 'antarctic', 'arctic', 'western_hemisphere' and 'eastern_hemisphere'}

\item{technical_specs_url}{a character string specifying the technical specs website}

\item{verbose}{a boolean. If TRUE then information will be printed out in the console}
}
\value{
a list object with the available nominal orbits
}
\description{
This function allows the user to view the nominal orbits (all or a selection)
}
\examples{

require(IceSat2R)

#.............................
# all available nominal orbits
#.............................

nomin_orb = available_nominal_orbits(verbose = TRUE)
nomin_orb

#........................
# specific nominal orbits
#........................

nomin_orb = available_nominal_orbits(orbit_area = 'arctic',
                                     verbose = TRUE)
nomin_orb

}
\references{
https://icesat-2.gsfc.nasa.gov/science/specs
}
