% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISRaD.extra.norm14c_year.R
\name{ISRaD.extra.norm14c_year}
\alias{ISRaD.extra.norm14c_year}
\title{ISRaD.extra.norm14c_year}
\usage{
ISRaD.extra.norm14c_year(
  obs_d14c,
  obs_year,
  atm_zone,
  norm_year,
  df,
  slow = TRUE,
  tau = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{obs_d14c}{column name in df with observed delta 14c values to be normalized OR numeric value}

\item{obs_year}{column name in df with year in which obs_d14c was observed (sample collection year) OR numeric value}

\item{atm_zone}{column name in df with atmospheric zone for obs_d14c OR character string. Notes: column values/character string must be one of c("NHc14", "SHc14", "Tropicsc14"). "NHc14" = > 30 degrees latitude; "SHc14" = < -30 latitude; "Tropicsc14" = < 30 & > -30 degrees latitude.}

\item{norm_year}{desired normalization year (numeric)}

\item{df}{data frame with columns for observed d14c (obs_d14c), observation year (obs_year), and atmospheric zone (atm_zone)}

\item{slow}{if TRUE (default) normalized 14c value will be fit using the slower solution for tau}

\item{tau}{if TRUE (default) the solution for tau will be returned along with the normalized 14c value}

\item{verbose}{Show progress bar? TRUE/FALSE (default = TRUE)}
}
\value{
data frame with new columns: "norm_14c", "norm_error", and optionally "norm_tau"; OR list with length = 3: "norm_14c", "norm_tau", "norm_error". Note that if is parameter df is not NULL and obs_d14c contains an underscore, e.g. "lyr_14c", supplied names will take the form "lyr_norm_14c", "lyr_norm_error", etc.
}
\description{
Normalizes delta 14c values to a given year (norm_year)
}
\details{
This function can be run on a data frame or with single value input. For the data frame method, the inputs 'obs_d14c', 'obs_year', and 'atm_zone' correspond to column names in the supplied data frame (see Example 1). For the single value method, the inputs for 'obs_d14c', 'obs_year', and 'atm_zone' are single values (Example 2).\cr\cr
The function works by creating a one pool steady-state model using atmospheric 14c over the period 1850 to 2021. Turnover time (tau^-1) is determined by fitting the model to the observed delta 14c (obs_d14c) in the given observation year (obs_year), and the normalized 14c value is calculated by running the model forwards or backwards to the desired normalization year (norm_year). Note that highly negative values of delta 14c (e.g. < -100) are unaffected by normalization and are thus returned unchanged by the function.\cr\cr
The curvature of the bomb peak can lead to two viable solutions for tau in a one pool model. Determining which value is more appropriate depends on the carbon dynamics of the system and thus cannot be determined a priori (Trumbore 2000). The 'slow' parameter can be used to select which tau is used for calculating the normalized 14c value. If 'slow' = TRUE, and the algorithm is able to find two solutions for tau, the function will return normalized 14c values calculated with the slower of the two turnover time solutions. If "slow" = FALSE, the faster turnover time is used.\cr\cr
In certain cases the algorithm used to determine tau fails to converge. This situation arises when observed radiocarbon values are too high relative to the year of observation. This problem is well documented (Gaudinski et al. 2000), and can be solved by introducing a time-lag for the carbon inputs to the system. However, this functionality is beyond the scope of this function. If the algorithm fails to converge, the function will select the tau value giving the closest match for observed 14c in the given observation year and return norm_error = "TRUE".\cr\cr
Example 1 shows how to run the function when the 'df' argument corresponds to a table from an ISRaD object, e.g. "flux", "layer", etc.\cr
Example 2 shows how to run the function when single values are supplied and 'df' is absent.\cr\cr
Note: There is no guarantee that normalized 14c values will be meaningful as the model assumes a well-mixed homogenous system, and this is rarely the case in soils.
}
\examples{
# Load example dataset Gaudinski_2001
database <- ISRaD::Gaudinski_2001
# Fill profile coordinates
database.x <- ISRaD.extra.fill_coords(database)
# Fill dates
database.x <- ISRaD.extra.fill_dates(database.x)
# Fill delta 14C from fraction modern
database.x <- ISRaD.extra.fill_rc(database.x)
# Fill atmospheric 14c
database.x <- ISRaD.extra.calc_atm14c(database.x)
# Run normalization function for the year 2010 with layer data
# Example 1
database.x$layer <- ISRaD.extra.norm14c_year(
  obs_d14c = "lyr_14c",
  obs_year = "lyr_obs_date_y",
  atm_zone = "pro_graven_zone",
  norm_year = 2010,
  tau = TRUE,
  df = database.x$layer,
  verbose = TRUE
)
# Example 2
ISRaD.extra.norm14c_year(
  obs_d14c = 182.8958,
  obs_year = 1996,
  atm_zone = "NHc14",
  norm_year = 2010
)
}
\references{
Gaudinski et al. 2000. Soil carbon cycling in a temperate forest: radiocarbon-based estimates of residence times, sequestration rates and partitioning of fluxes. Biogeochemistry 51: 33–69 \doi{10.1023/A:1006301010014}\cr\cr
Trumbore, S. 2000. Age of Soil Organic Matter and Soil Respiration: Radiocarbon Constraints on Belowground C Dynamics. Ecological Applications, 10(2): 399–411 \doi{10.2307/2641102}
}
\author{
J. Beem-Miller and J. Randerson
}
