% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataSetList.R
\name{generate_data.Single_Function}
\alias{generate_data.Single_Function}
\title{Generate dataframe of a single function/dimension pair}
\usage{
generate_data.Single_Function(
  dsList,
  start = NULL,
  stop = NULL,
  scale_log = F,
  which = "by_RT",
  include_opts = F,
  budget = NULL,
  include_geom_mean = F
)
}
\arguments{
\item{dsList}{The DataSetList object}

\item{start}{Optional start value (Runtime or target value)}

\item{stop}{Optional end value (Runtime or target value)}

\item{scale_log}{Wheterh to use logarithmic scaling or not}

\item{which}{Whether to use a fixed-target 'by_RT' perspective or fixed-budget 'by_FV'}

\item{include_opts}{Whether or not to also include the best value hit by each algorithm to
the generated datapoints}

\item{budget}{Optional; overwrites the budget of each individual algorithm when doing ERT calculations. Only works
in fixed_target mode.}

\item{include_geom_mean}{Boolean to indicate whether to include the geometric mean.
Only works in fixed_budget mode. Negative values cause NaN, zeros cause output to be completely 0. Defaults to False.}
}
\description{
This function generates a dataframe which can be easily plotted using the `plot_general_data`-function
}
\examples{
generate_data.Single_Function(subset(dsl, funcId == 1), which = 'by_RT')
}
