% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDataSetList.R
\name{Plot.FV.ECDF_Single_Func}
\alias{Plot.FV.ECDF_Single_Func}
\alias{Plot.FV.ECDF_Single_Func.DataSetList}
\title{Plot the aggregated empirical cumulative distriburtion as a function of the function values of
a DataSetList.}
\usage{
Plot.FV.ECDF_Single_Func(
  dsList,
  rt_min = NULL,
  rt_max = NULL,
  rt_step = NULL,
  scale.xlog = F,
  show.per_target = F,
  scale.reverse = F
)

\method{Plot.FV.ECDF_Single_Func}{DataSetList}(
  dsList,
  rt_min = NULL,
  rt_max = NULL,
  rt_step = NULL,
  scale.xlog = F,
  show.per_target = F,
  scale.reverse = F
)
}
\arguments{
\item{dsList}{A DataSetList (should consist of only one function and dimension).}

\item{rt_min}{The starting runtime}

\item{rt_max}{The final runtime}

\item{rt_step}{The spacing between starting and final runtimes}

\item{scale.xlog}{Whether or not to scale the x-axis logaritmically}

\item{show.per_target}{Whether or not to show the individual ECDF-curves for each runtime}

\item{scale.reverse}{Whether or not to reverse the x-axis (when using minimization)}
}
\value{
A plot of the empirical cumulative distriburtion as a function of
the function values of the DataSetList
}
\description{
Plot the aggregated empirical cumulative distriburtion as a function of the function values of
a DataSetList.
}
\examples{
Plot.FV.ECDF_Single_Func(subset(dsl, funcId == 1))
}
