% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toomany.R
\name{toomany}
\alias{toomany}
\title{Looks if a value is repeated too many times}
\usage{
toomany(y, blockmany = 15, scope = 1, exclude = NULL)
}
\arguments{
\item{y}{two columns with date and data}

\item{blockmany}{maximum number of repeated values in a month, year, or season}

\item{scope}{monthly (1), annual (2)}

\item{exclude}{values to exclude, e.g. if precipitation, 0 must be excluded}
}
\value{
list of positions which do not pass this QC test. If all positions pass the test, returns NULL
}
\description{
This function splits data by month and looks if a value is repeated too many times
}
\examples{
#Extract the ECA&D data file (maximum air temperature) from the example data folder
path2inptfl<-system.file("extdata", "TX_SOUID132734.txt", package = "INQC")
#Read the data file
y<-readecad(input=path2inptfl,missing= -9999)[,3:4]
#Introduce the errors in first 20 data values
y[1:20,2]<-30
#Find all suspicious positions in the time series
toomany(y,blockmany=15,scope=1,exclude=NULL)

#Extract the ECA&D data file (atmospheric precipitation) from the example data folder
path2inptfl<-system.file("extdata", "RR_SOUID132730.txt", package = "INQC")
#Read the data file
y<-readecad(input=path2inptfl,missing= -9999)[,3:4]
#Introduce the errors in first 20 data values
y[1:20,2]<-10
#Find all suspicious positions in the time series
toomany(y,blockmany=15,scope=1,exclude=0)
}
