% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_inla_residuals.R
\name{ggplot_inla_residuals}
\alias{ggplot_inla_residuals}
\title{Plot residuals of observed vs predicted values for INLA model using ggplot2}
\usage{
ggplot_inla_residuals(inla.model, observed, CI = FALSE, binwidth = NULL)
}
\arguments{
\item{inla.model}{An inla object}

\item{observed}{The observed values}

\item{CI}{Add credible intervals to the fitted values?}

\item{binwidth}{The size of the bins used for the histogram. If NULL ggplot guesses for you.}
}
\description{
Plot residuals of observed vs predicted values for INLA model using ggplot2
}
\examples{
\dontrun{
 library(INLA)
 data(Epil)
 observed <- Epil[1:30, 'y']
 Epil <- rbind(Epil, Epil[1:30, ])
 Epil[1:30, 'y'] <- NA
 ## make centered covariates
 formula = y ~ Trt + Age + V4 +
          f(Ind, model="iid") + f(rand,model="iid")
 result = inla(formula, family="poisson", data = Epil, 
               control.predictor = list(compute = TRUE, link = 1))
 ggplot_inla_residuals(result, observed)
 

 data(Seeds)
 l <- nrow(Seeds)
 Seeds <- rbind(Seeds, Seeds)
 Seeds$r[1:l] <- NA


 formula = r ~ x1 * x2 + f(plate, model = "iid")
 mod.seeds = inla(formula, data=Seeds, family = "binomial", Ntrials = n, 
                  control.predictor = list(compute = TRUE, link = 1))
 ggplot_inla_residuals(mod.seeds, na.omit(Seeds$r / Seeds$n))
}
}
