% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlottingFunctions.R
\name{mat2cols}
\alias{mat2cols}
\title{Convert a numeric matrix to colours}
\usage{
mat2cols(mat, cols = NULL, byrank = FALSE, breaks = length(cols))
}
\arguments{
\item{mat}{A matrix.}

\item{cols}{The colour palette to be used. The default palette uses \code{\link[viridis]{viridis}}. Will be checked for validity.}

\item{byrank}{Logical indicating whether to convert the matrix itself or the sample ranks of the values therein. Defaults to FALSE.}

\item{breaks}{Number of gradations in colour to use. Defaults to \code{length(cols)}.}
}
\value{
A matrix of hex colour code representations.
}
\description{
Converts a matrix to a hex colour code representation for plotting using \code{\link[gclus]{plotcolors}}. Used internally by \code{\link{plot.Results_IMIFA}} for plotting posterior mean loadings heatmaps.
}
\examples{
mat  <- matrix(rnorm(100), nrow=10, ncol=10)
cols <- mat2cols(mat)
cols

# Use gclus::plotcolors() to visualise the colours matrix
# plotcolors(cols)
}
\seealso{
\code{\link[gclus]{plotcolors}}
}

