% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.lab.fqcs.R
\name{plot.lab.fqcd}
\alias{plot.lab.fqcd}
\title{Plotting method for 'lab.fqcd' objects}
\usage{
\method{plot}{lab.fqcd}(x, main = NULL, xlab = NULL, ylab = NULL,
  ylim = NULL, x.co = NULL, y.co = NULL, legend = TRUE, col = NULL,
  ...)
}
\arguments{
\item{x}{Object lab.fqcd (Functional Quality Control Data)}

\item{main}{Main title for the plot}

\item{xlab}{Title for the x axis}

\item{ylab}{Title for the y axis}

\item{ylim}{The y limits of the plot}

\item{x.co}{It speficies the x co-ordinates to be used to place a legend.}

\item{y.co}{It specifies the y co-ordinates to be used to place a legend.}

\item{legend}{Logical argument. Default is TRUE then The legend default is used.}

\item{col}{Color specifications}

\item{...}{Arguments to be passed to or from methods.}
}
\description{
Generic function to plot objects of 'lab.fqcd' class
}
\examples{
library(ILS)
data(TG)
delta <- seq(from = 40 ,to = 850 ,length.out = 1000 )
curves.fqcd <- lab.fqcd(TG, argvals = delta)
xlab <- "Temperature/ C"
ylab <- "Mass/ \%"
main <- "TG curves obtained from calcium oxalate"
p <- dim(curves.fqcd$curves)[3]
col <- 1:p
plot(x = curves.fqcd, main, xlab, ylab, col= col,legend = FALSE)
legend(45,70,paste("Lab",col),
      col = col, lty = 1, lwd = 2, cex =0.8)

}
\references{
\describe{
  \item{}{Febrero-Bande, M. and Oviedo, M. (2012),
   "Statistical computing in functional data analysis: the R package fda.usc". Journal of Statistical Software 51 (4), 1-28.}
  \item{}{Naya, S., Tarrio-Saavedra. J., Lopez- Beceiro, J., Francisco Fernandez, M., Flores, M. and  Artiaga, R. (2014), 
  "Statistical functional approach for interlaboratory studies with thermal data". Journal of Thermal Analysis and Calorimetry, 118,1229-1243.}
}
}

