% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IGP_CGP.R
\docType{class}
\name{IGP_CGP}
\alias{IGP_CGP}
\title{IGP R6 object for fitting CGP model}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} with methods for fitting GP model.
}
\description{
Class providing object with methods for fitting a GP model
}
\section{Methods}{

\describe{
  \item{Documentation}{For full documentation of each method go to https://github.com/CollinErickson/IGP/}
  \item{\code{new(X=NULL, Z=NULL, package=NULL,
  estimate.nugget=T, nugget0=F, ...)}}{This method
  is used to create object of this class with \code{X} and \code{Z} as the data.
  The package tells it which package to fit the GP model.}
  \item{\code{update(Xall=NULL, Zall=NULL, Xnew=NULL, Znew=NULL, ...)}}{This method
  updates the model, adding new data if given, then running optimization again.}}
}

\examples{
\donttest{
# Takes 17 seconds
n <- 20
d <- 2
n2 <- 20
f1 <- function(x) {sin(2*pi*x[1]) + sin(2*pi*x[2])}
X1 <- matrix(runif(n*d),n,d)
Z1 <- apply(X1,1,f1) + rnorm(n, 0, 1e-3)
X2 <- matrix(runif(n2*d),n2,d)
Z2 <- apply(X2,1,f1)
XX1 <- matrix(runif(10),5,2)
ZZ1 <- apply(XX1, 1, f1)
u <- IGP_CGP$new(X=X1,Z=Z1)
cbind(u$predict(XX1), ZZ1)
u$predict.se(XX1)
u$update(Xnew=X2,Znew=Z2)
cbind(u$predict(XX1), ZZ1)
u$delete()
}
}
\references{
Ba, S. and V. Roshan Joseph (2012) "Composite Gaussian Process Models for Emulating Expensive Functions". Annals of Applied Statistics, 6, 1838-1860.
}
\section{Super class}{
\code{\link[IGP:IGP]{IGP::IGP}} -> \code{IGP_CGP}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{X}}{Design matrix}

\item{\code{Z}}{Responses}

\item{\code{N}}{Number of data points}

\item{\code{D}}{Dimension of data}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{X}}{Design matrix}

\item{\code{Z}}{Responses}

\item{\code{N}}{Number of data points}

\item{\code{D}}{Dimension of data}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-IGP_CGP-.init}{\code{IGP_CGP$.init()}}
\item \href{#method-IGP_CGP-.update}{\code{IGP_CGP$.update()}}
\item \href{#method-IGP_CGP-.predict}{\code{IGP_CGP$.predict()}}
\item \href{#method-IGP_CGP-.predict.se}{\code{IGP_CGP$.predict.se()}}
\item \href{#method-IGP_CGP-.predict.var}{\code{IGP_CGP$.predict.var()}}
\item \href{#method-IGP_CGP-.delete}{\code{IGP_CGP$.delete()}}
\item \href{#method-IGP_CGP-.theta}{\code{IGP_CGP$.theta()}}
\item \href{#method-IGP_CGP-.nugget}{\code{IGP_CGP$.nugget()}}
\item \href{#method-IGP_CGP-.s2}{\code{IGP_CGP$.s2()}}
\item \href{#method-IGP_CGP-.mean}{\code{IGP_CGP$.mean()}}
\item \href{#method-IGP_CGP-clone}{\code{IGP_CGP$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="IGP" data-topic="IGP" data-id="at.max.var"><a href='../../IGP/html/IGP.html#method-IGP-at.max.var'><code>IGP::IGP$at.max.var()</code></a></span></li>
<li><span class="pkg-link" data-pkg="IGP" data-topic="IGP" data-id="delete"><a href='../../IGP/html/IGP.html#method-IGP-delete'><code>IGP::IGP$delete()</code></a></span></li>
<li><span class="pkg-link" data-pkg="IGP" data-topic="IGP" data-id="finalize"><a href='../../IGP/html/IGP.html#method-IGP-finalize'><code>IGP::IGP$finalize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="IGP" data-topic="IGP" data-id="grad"><a href='../../IGP/html/IGP.html#method-IGP-grad'><code>IGP::IGP$grad()</code></a></span></li>
<li><span class="pkg-link" data-pkg="IGP" data-topic="IGP" data-id="grad_from_theta"><a href='../../IGP/html/IGP.html#method-IGP-grad_from_theta'><code>IGP::IGP$grad_from_theta()</code></a></span></li>
<li><span class="pkg-link" data-pkg="IGP" data-topic="IGP" data-id="grad_norm"><a href='../../IGP/html/IGP.html#method-IGP-grad_norm'><code>IGP::IGP$grad_norm()</code></a></span></li>
<li><span class="pkg-link" data-pkg="IGP" data-topic="IGP" data-id="grad_num"><a href='../../IGP/html/IGP.html#method-IGP-grad_num'><code>IGP::IGP$grad_num()</code></a></span></li>
<li><span class="pkg-link" data-pkg="IGP" data-topic="IGP" data-id="init"><a href='../../IGP/html/IGP.html#method-IGP-init'><code>IGP::IGP$init()</code></a></span></li>
<li><span class="pkg-link" data-pkg="IGP" data-topic="IGP" data-id="initialize"><a href='../../IGP/html/IGP.html#method-IGP-initialize'><code>IGP::IGP$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="IGP" data-topic="IGP" data-id="max.var"><a href='../../IGP/html/IGP.html#method-IGP-max.var'><code>IGP::IGP$max.var()</code></a></span></li>
<li><span class="pkg-link" data-pkg="IGP" data-topic="IGP" data-id="mean"><a href='../../IGP/html/IGP.html#method-IGP-mean'><code>IGP::IGP$mean()</code></a></span></li>
<li><span class="pkg-link" data-pkg="IGP" data-topic="IGP" data-id="nugget"><a href='../../IGP/html/IGP.html#method-IGP-nugget'><code>IGP::IGP$nugget()</code></a></span></li>
<li><span class="pkg-link" data-pkg="IGP" data-topic="IGP" data-id="plot"><a href='../../IGP/html/IGP.html#method-IGP-plot'><code>IGP::IGP$plot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="IGP" data-topic="IGP" data-id="predict"><a href='../../IGP/html/IGP.html#method-IGP-predict'><code>IGP::IGP$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="IGP" data-topic="IGP" data-id="predict.se"><a href='../../IGP/html/IGP.html#method-IGP-predict.se'><code>IGP::IGP$predict.se()</code></a></span></li>
<li><span class="pkg-link" data-pkg="IGP" data-topic="IGP" data-id="predict.var"><a href='../../IGP/html/IGP.html#method-IGP-predict.var'><code>IGP::IGP$predict.var()</code></a></span></li>
<li><span class="pkg-link" data-pkg="IGP" data-topic="IGP" data-id="prop.at.max.var"><a href='../../IGP/html/IGP.html#method-IGP-prop.at.max.var'><code>IGP::IGP$prop.at.max.var()</code></a></span></li>
<li><span class="pkg-link" data-pkg="IGP" data-topic="IGP" data-id="s2"><a href='../../IGP/html/IGP.html#method-IGP-s2'><code>IGP::IGP$s2()</code></a></span></li>
<li><span class="pkg-link" data-pkg="IGP" data-topic="IGP" data-id="sample"><a href='../../IGP/html/IGP.html#method-IGP-sample'><code>IGP::IGP$sample()</code></a></span></li>
<li><span class="pkg-link" data-pkg="IGP" data-topic="IGP" data-id="theta"><a href='../../IGP/html/IGP.html#method-IGP-theta'><code>IGP::IGP$theta()</code></a></span></li>
<li><span class="pkg-link" data-pkg="IGP" data-topic="IGP" data-id="update"><a href='../../IGP/html/IGP.html#method-IGP-update'><code>IGP::IGP$update()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IGP_CGP-.init"></a>}}
\if{latex}{\out{\hypertarget{method-IGP_CGP-.init}{}}}
\subsection{Method \code{.init()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IGP_CGP$.init(...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IGP_CGP-.update"></a>}}
\if{latex}{\out{\hypertarget{method-IGP_CGP-.update}{}}}
\subsection{Method \code{.update()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IGP_CGP$.update(...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IGP_CGP-.predict"></a>}}
\if{latex}{\out{\hypertarget{method-IGP_CGP-.predict}{}}}
\subsection{Method \code{.predict()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IGP_CGP$.predict(XX, se.fit, ...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IGP_CGP-.predict.se"></a>}}
\if{latex}{\out{\hypertarget{method-IGP_CGP-.predict.se}{}}}
\subsection{Method \code{.predict.se()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IGP_CGP$.predict.se(XX, ...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IGP_CGP-.predict.var"></a>}}
\if{latex}{\out{\hypertarget{method-IGP_CGP-.predict.var}{}}}
\subsection{Method \code{.predict.var()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IGP_CGP$.predict.var(XX, ...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IGP_CGP-.delete"></a>}}
\if{latex}{\out{\hypertarget{method-IGP_CGP-.delete}{}}}
\subsection{Method \code{.delete()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IGP_CGP$.delete(...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IGP_CGP-.theta"></a>}}
\if{latex}{\out{\hypertarget{method-IGP_CGP-.theta}{}}}
\subsection{Method \code{.theta()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IGP_CGP$.theta()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IGP_CGP-.nugget"></a>}}
\if{latex}{\out{\hypertarget{method-IGP_CGP-.nugget}{}}}
\subsection{Method \code{.nugget()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IGP_CGP$.nugget()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IGP_CGP-.s2"></a>}}
\if{latex}{\out{\hypertarget{method-IGP_CGP-.s2}{}}}
\subsection{Method \code{.s2()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IGP_CGP$.s2()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IGP_CGP-.mean"></a>}}
\if{latex}{\out{\hypertarget{method-IGP_CGP-.mean}{}}}
\subsection{Method \code{.mean()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IGP_CGP$.mean()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IGP_CGP-clone"></a>}}
\if{latex}{\out{\hypertarget{method-IGP_CGP-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IGP_CGP$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
