% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strings_utils.R
\name{gseq}
\alias{gseq}
\title{String Sequence Replacement}
\usage{
gseq(x, pattern = "", replacement = character(), all = TRUE)
}
\arguments{
\item{x, pattern, replacement}{non empty character vectors.}

\item{all}{whether to replace all instances of 'pattern' or only the 1st one. Default is TRUE, to replace all instances.}
}
\value{
'x' where 'pattern' is replaced by replacement.
}
\description{
Replaces a sequence of strings
}
\details{
if 'pattern' is found within 'x', 'pattern' will be removed from 'x' and replace by 'replacement'.\cr
It looks like gsub but it is different e.g.:\cr
x=c("ABD","A","B")\cr
pattern=c("A","B")\cr
replacement=c("C")\cr
- gsub(x=paste0(x,collapse=""),pattern=paste0(pattern,collapse=""),replacement=paste0(replacement,collapse=""),fixed=TRUE) will give "CDC",\cr
- gseq(x=x,pattern=pattern,replacement=replacement) will give "ABD","C".
}
\keyword{internal}
