% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objectCleanse.R
\name{objectCleanse}
\alias{objectCleanse}
\title{Object Cleanser}
\usage{
objectCleanse(mat, msk, add_noise = TRUE, random_seed = NULL, bg = 0, sd = 0)
}
\arguments{
\item{mat}{a numeric matrix (image).}

\item{msk}{a numeric matrix (mask identifying abnormalities).}

\item{add_noise}{if TRUE adds normal noise to background using rnorm(), from \pkg{Rcpp}. Default is TRUE.}

\item{random_seed}{a single value, interpreted as an integer, or NULL to be used with set.seed() from \pkg{base} when 'add_noise' is set to TRUE. Default is NULL.}

\item{bg}{mean value of the background added if add_noise is TRUE. Default is 0.}

\item{sd}{standard deviation of the background added if add_noise is TRUE. Default is 0.}
}
\value{
According to msk, pixel values in mat are substituted by either bg [add_noise == FALSE] or rnorm(n = prod(dim(mat), mean=bg, sd=sd)) [add_noise == TRUE].
}
\description{
Removes abnormalities (clipped/debris) from image.
}
