% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popsNetwork.R
\name{popsNetwork}
\alias{popsNetwork}
\title{IFC_pops Network Display}
\usage{
popsNetwork(
  obj,
  hierarchical = TRUE,
  color_mode = "white",
  highlight = NULL,
  seed = NULL,
  direction = "LR",
  weighted = TRUE,
  ...
)
}
\arguments{
\item{obj}{an `IFC_data` object extracted with features extracted.}

\item{hierarchical}{whether to display network using a hierarchical layout or not. Default is TRUE.}

\item{color_mode}{Whether to extract colors from 'obj' in "white" or "black" mode. Default is "white".}

\item{highlight}{population to permanently highlight. If found in 'obj', this population will be displayed with its color. Default is NULL.}

\item{seed}{If you provide a seed manually, the layout will be the same every time. Default is NULL.}

\item{direction}{The direction of the hierarchical layout. Default is 'LR'.\cr
The available options are: 'UD', 'DU', 'LR', 'RL'. To simplify: up-down, down-up, left-right, right-left.}

\item{weighted}{whether to scale population's node size according to count. Default is TRUE.}

\item{...}{other argument to be passed.}
}
\value{
a \pkg{visNetwork} object.
}
\description{
Builds and displays populations network.
}
\examples{
if(requireNamespace("IFCdata", quietly = TRUE)) {
  ## use a daf file
  file_daf <- system.file("extdata", "example.daf", package = "IFCdata")
  daf <- ExtractFromDAF(fileName = file_daf)
  popsNetwork(obj = daf)
} else {
  message(sprintf('Please run `install.packages("IFCdata", repos = "\%s", type = "source")` \%s',
                  'https://gitdemont.github.io/IFCdata/',
                  'to install extra files required to run this example.'))
}
}
