% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qs2.R
\name{qs2}
\alias{qs2}
\title{Power of interactive determinant for multiple explanatory variables
in IDSA model.}
\usage{
qs2(y, x, xoverlay, location)
}
\arguments{
\item{y}{A numeric vector of a response variable}

\item{x}{A numeric vector of a explanatory variable}

\item{xoverlay}{A character variable of an explanatory variable}

\item{location}{A matrix of spatial locations}
}
\value{
A power of interactive determinant (PID) value from IDSA model.
}
\description{
Power of interactive determinant for multiple explanatory variables
in IDSA model.
}
\examples{
library(GD)
data <- sim[,4:6]
data.disc <- apply(data, 2, FUN = function(x) disc(x, 4, "quantile"))
layers <- do.call(cbind, lapply(1:ncol(data), function(x)
  data.frame(cut(data[, x], data.disc[[x]]$itv, include.lowest = TRUE))))
names(layers) <- names(data)
fo <- fuzzyoverlay(y = sim[,1], layers = layers, method = "fuzzyAND")
q.idsa <- qs2(y = sim$y, x = data, xoverlay = fo$fuzzylayer,
              location = sim[, c("lo","la")])

}
