% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzyoverlay.R
\name{fuzzyoverlay}
\alias{fuzzyoverlay}
\title{Spatial fuzzy overlay.}
\usage{
fuzzyoverlay(y, layers, method = "fuzzyAND")
}
\arguments{
\item{y}{A numeric vector of a response variable}

\item{layers}{A data frame of spatial layers of explanatory variables.}

\item{method}{A character of overlay methods,
including "fuzzyAND" and "fuzzyOR"}
}
\value{
A data frame of a spatial fuzzy overlay variable.
}
\description{
Spatial fuzzy overlay.
}
\examples{
library(GD)
data <- sim[, 4:6]
data.disc <- apply(data, 2, FUN = function(x) disc(x, 4, "quantile"))
layers <- do.call(cbind, lapply(1:ncol(data), function(x)
  data.frame(cut(data[, x], data.disc[[x]]$itv, include.lowest = TRUE))))
names(layers) <- names(data)
fo <- fuzzyoverlay(y = sim[,1], layers = layers, method = "fuzzyAND")

}
