% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SingleMiRNA_CRModel.R
\name{SingleMiRNA_CRModel}
\alias{SingleMiRNA_CRModel}
\title{SingleMiRNA_CRModel}
\usage{
SingleMiRNA_CRModel(ExpData,MiRNA,cutoff.point=NULL,SurvivalData)
}
\arguments{
\item{ExpData}{A gene expression profile of interest (rows are genes, columns are samples).}

\item{MiRNA}{A miRNA ID.}

\item{cutoff.point}{A numeric value is used to divide high-risk and low-risk groups.}

\item{SurvivalData}{Survival data (the column names are: "sample", "status", "time") corresponding to samples in the gene expression profile of interest.}
}
\value{
A list includes a data frame with seven parts those are "sample", "status", "time", "target genes expression", "risk score", "group", and a dataframe with five columns those are "Gene", "HR", "HR.95L", "HR.95H", "beta", and "P-value".
}
\description{
Function "SingleMiRNA_CRModel" uses survival data to build a multivariate Cox model using the targets of a single miRNA.
}
\examples{
# Obtain the example data
GEP<-GetData_Mirna("GEP")
survival<-GetData_Mirna("survival")
# Run the function
SingleMiRNA_CRData<-SingleMiRNA_CRModel(GEP,
"hsa-miR-21-5p",cutoff.point=NULL,survival)
}
