% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IDF.R
\name{IDF.agg}
\alias{IDF.agg}
\title{Aggregation and annual maxima for chosen durations}
\usage{
IDF.agg(
  data,
  ds,
  na.accept = 0,
  which.stations = NULL,
  which.mon = list(0:11),
  names = c("date", "RR"),
  cl = 1
)
}
\arguments{
\item{data}{list of data.frames containing time series for every station. 
The data.frame must have the columns 'date' and 'RR' unless other names 
are specified in the parameter `names`. The column 'date' must contain strings with 
standard date format.}

\item{ds}{numeric vector of aggregation durations in hours. 
(Must be multiples of time resolution at all stations.)}

\item{na.accept}{numeric in [0,1) giving maximum percentage of missing values 
for which block max. should still be calculated.}

\item{which.stations}{optional, subset of stations. Either numeric vector or character vector 
containing names of elements in data. If not given, all elements in `data` will be used.}

\item{which.mon}{optional, subset of months (as list containing values from 0 to 11) of which to calculate the annual maxima from.}

\item{names}{optional, character vector of length 2, containing the names of the columns to be used.}

\item{cl}{optional, number of cores to be used from \code{\link[parallel]{parLapply}} for parallel computing.}
}
\value{
data.frame containing the annual intensity maxima [mm/h] in `$xdat`, the corresponding duration in `$ds`,
the `$year` and month (`$mon`) in which the maxima occurred 
and the station id or name in `$station`.
}
\description{
Aggregates several time series for chosen durations and finds annual maxima 
(either for the whole year or chosen months). Returns data.frame that can be used for
the function \code{\link{gev.d.fit}}.
}
\details{
If data contains stations with different time resolutions that need to be aggregated at
different durations, IDF.agg needs to be run separately for the different groups of stations. 
Afterwards the results can be joint together using `rbind`.
}
\examples{
dates <- as.Date("2019-01-01")+0:729
x <- rgamma(n = 730, shape = 0.4, rate = 0.5)
df <- data.frame(date=dates,RR=x)

# get annual maxima
IDF.agg(list('Sample'= df),ds=c(24,48),na.accept = 0.01)

##      xdat ds year  mon station
## 0.2853811 24 2019 0:11  Sample
## 0.5673122 24 2020 0:11  Sample
## 0.1598448 48 2019 0:11  Sample
## 0.3112713 48 2020 0:11  Sample

# get monthly maxima for each month of june, july and august
IDF.agg(list('Sample'=df),ds=c(24,48),na.accept = 0.01,which.mon = list(5,6,7))

# get maxima for time range from june to august
IDF.agg(list('Sample'=df),ds=c(24,48),na.accept = 0.01,which.mon = list(5:7))

}
\seealso{
\code{\link{pgev.d}}
}
