% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acquire.R
\name{get_data}
\alias{get_data}
\title{Download and Load Complex Network Datasets}
\usage{
get_data(dataset_name, destdir = ".")
}
\arguments{
\item{dataset_name}{dataset variable name (corresponds to var_name in ICON_data)}

\item{destdir}{location to temporarily download binary file}
}
\description{
Downloads the binary complex network dataset (rda format), then loads
the dataset into the R environment, and deletes the downloaded file
from the user's file system.
}
\examples{
\dontrun{
# load single dataset
get_data("chess")

# load multiple datasets
get_data(c("karate_club", "word_adj"))

# fail to load dataset not in the ICON R package
get_data("not_a_dataset")
}
}
