% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotSubpath.r
\name{PlotSubpathway}
\alias{PlotSubpathway}
\title{PlotSubpathway}
\usage{
PlotSubpathway(subpID, pathway.name, zz, Pathway = "kegg",
  layout = layout.fruchterman.reingold)
}
\arguments{
\item{subpID}{gene list of a interested subpathway}

\item{pathway.name}{name of the interested subpathway}

\item{zz}{z-score of each gene}

\item{Pathway}{the name of the pathway database}

\item{layout}{The layout specification(\code{\link[igraph]{layout_}}). It must be a call to a layout specification function.}
}
\value{
Network graph
}
\description{
PlotSubpathway:plot a network graph when user input a list of gene
}
\examples{
require(graphite)

subpID<-unlist(strsplit("G6PC/HK3/GPI/FBP1/ALDOA/G6PC2","/"))
pathway.name="Glycolysis / Gluconeogenesis"
zzz<- GetExampleData("zzz")
\dontrun{PlotSubpathway(subpID=subpID,pathway.name=pathway.name,zz=zzz)}
}
