% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{FIM_exp_2par}
\alias{FIM_exp_2par}
\title{Fisher Information Matrix for the 2-Parameter Exponential Model}
\usage{
FIM_exp_2par(x, w, param)
}
\arguments{
\item{x}{Vector of design points.}

\item{w}{Vector of design weight. Its length must be equal to the length of \code{x} and \code{sum(w) = 1}.}

\item{param}{Vector of values for the model parameters \code{c(a, b)}.}
}
\value{
Fisher information matrix.
}
\description{
It provides the cpp function for FIM for the model  \code{~a + exp(-b*x)}.
}
\details{
The FIM does not depend on the value of \code{a}.
}
\examples{
FIM_exp_2par(x = c(1, 2), w = c(.5, .5), param = c(3, 4))
}
\references{
Dette, H., & Neugebauer, H. M. (1997). Bayesian D-optimal designs for exponential regression models. Journal of Statistical Planning and Inference, 60(2), 331-349.
}
