% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{FIM_logistic}
\alias{FIM_logistic}
\title{Fisher information matrix for the two-parameter logistic (2PL) model.}
\usage{
FIM_logistic(x, w, param)
}
\arguments{
\item{x}{vector of design points. In IRT, \eqn{x} is the person ability parameter.}

\item{w}{vector of design weight. Its length must be equal to the length of \code{x} and \code{sum(w)} should be 1.}

\item{param}{vector of model parameters \eqn{\bold{\theta} = (a, b)}. In IRT parameter
\eqn{a} is the item difficulty parameter and parameter \eqn{b} is the item discrimination parameter.}
}
\value{
Fisher information matrix.
}
\description{
The mean of response variable is \deqn{f(x, \bold{\theta}) = \frac{1}{(1 + \exp(-b (x - a)))},}{f(x, \bold{\theta}) = 1/(1 + \exp(-b (x - a))),} where
\eqn{\bold{\theta} = (a, b)}.
}
\details{
There is no closed-form for the locally optimal design.
 For minimax and standardized D-optimal design, the optimal design is symmetric around point
\eqn{(a^L + a^U)/2}{(aL + aU)/2} where \eqn{a^L}{aL} and \eqn{a^U}{aU} are the
lower bound and upper bound for parameter \eqn{a}, respectively. In \code{\link{mica}},
 options \code{sym} and \code{sym_point} in \code{control} can be used to make the search
  for the optimal design easier.
}
\seealso{
Other FIM: \code{\link{FIM_comp_inhibition}},
  \code{\link{FIM_emax_3par}}, \code{\link{FIM_exp_2par}},
  \code{\link{FIM_exp_3par}},
  \code{\link{FIM_logisitic_1par}},
  \code{\link{FIM_logistic_4par}},
  \code{\link{FIM_loglin}}, \code{\link{FIM_michaelis}},
  \code{\link{FIM_mixed_inhibition}},
  \code{\link{FIM_noncomp_inhibition}},
  \code{\link{FIM_power_logistic}},
  \code{\link{FIM_uncomp_inhibition}}
}

