% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCF_to_catalog_functions.R
\name{ReadVCFs}
\alias{ReadVCFs}
\title{Read VCF files}
\usage{
ReadVCFs(
  files,
  variant.caller = "unknown",
  num.of.cores = 1,
  names.of.VCFs = NULL,
  tumor.col.names = NA,
  filter.status = NULL,
  get.vaf.function = NULL,
  ...
)
}
\arguments{
\item{files}{Character vector of file paths to the VCF files.}

\item{variant.caller}{Name of the variant caller that produces the VCF, can
be either \code{"strelka"}, \code{"mutect"}, \code{"freebayes"} or
\code{"unknown"}. This information is needed to calculate the VAFs (variant
allele frequencies). If variant caller is \code{"unknown"}(default) and
\code{get.vaf.function} is NULL, then VAF and read depth will be NAs. If
variant caller is \code{"mutect"}, do \strong{not} merge SBSs into DBS.}

\item{num.of.cores}{The number of cores to use. Not available on Windows
unless \code{num.of.cores = 1}.}

\item{names.of.VCFs}{Character vector of names of the VCF files. The order
of names in \code{names.of.VCFs} should match the order of VCF file paths
in \code{files}. If \code{NULL}(default), this function will remove all of
the path up to and including the last path separator (if any) and file
paths without extensions (and the leading dot) will be used as the names of
the VCF files.}

\item{tumor.col.names}{Optional. Only applicable to \strong{Mutect} VCFs.
Character vector of column names in \strong{Mutect} VCFs which contain the
tumor sample information. The order of names in \code{tumor.col.names}
should match the order of \strong{Mutect} VCFs specified in \code{files}.
If \code{tumor.col.names} is equal to \code{NA}(default), this function
will use the 10th column in all the \strong{Mutect} VCFs to calculate VAFs.
See \code{\link{GetMutectVAF}} for more details.}

\item{filter.status}{The status indicating a variant has passed all filters.
An example would be \code{"PASS"}. Variants which don't have the specified
\code{filter.status} in the \code{FILTER} column in VCF will be removed. If
\code{NULL}(default), no variants will be removed from the original VCF.}

\item{get.vaf.function}{Optional. Only applicable when \code{variant.caller} is
\strong{"unknown"}. Function to calculate VAF(variant allele frequency) and read
depth information from original VCF. See \code{\link{GetMutectVAF}} as an example.
If \code{NULL}(default) and \code{variant.caller} is "unknown", then VAF
and read depth will be NAs.}

\item{...}{Optional arguments to \code{get.vaf.function}.}
}
\value{
A list of data frames storing data lines of the VCF files with two
  additional columns added which contain the VAF(variant allele frequency)
  and read depth information.
}
\description{
Read VCF files
}
\keyword{internal}
