% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny_related_functions.R
\name{MutectVCFFilesToCatalog}
\alias{MutectVCFFilesToCatalog}
\title{Create SBS, DBS and Indel catalogs from Mutect VCF files}
\usage{
MutectVCFFilesToCatalog(
  files,
  ref.genome,
  trans.ranges = NULL,
  region = "unknown",
  names.of.VCFs = NULL,
  tumor.col.names = NA,
  flag.mismatches = 0
)
}
\arguments{
\item{files}{Character vector of file paths to the Mutect VCF files.}

\item{ref.genome}{A \code{ref.genome} argument as described in
\code{\link{ICAMS}}.}

\item{trans.ranges}{Optional. If \code{ref.genome} specifies one of the
\code{\link{BSgenome}} object 
\enumerate{
  \item \code{\link[BSgenome.Hsapiens.1000genomes.hs37d5]{BSgenome.Hsapiens.1000genomes.hs37d5}}
  \item \code{\link[BSgenome.Hsapiens.UCSC.hg38]{BSgenome.Hsapiens.UCSC.hg38}}
  \item \code{\link[BSgenome.Mmusculus.UCSC.mm10]{BSgenome.Mmusculus.UCSC.mm10}}
}
then the function will infer \code{trans.ranges} automatically. Otherwise,
user will need to provide the necessary \code{trans.ranges}. Please refer to
\code{\link{TranscriptRanges}} for more details.
If \code{is.null(trans.ranges)} do not add transcript range
information.}

\item{region}{A character string designating a genomic region;
see \code{\link{as.catalog}} and \code{\link{ICAMS}}.}

\item{names.of.VCFs}{Optional. Character vector of names of the VCF files.
The order of names in \code{names.of.VCFs} should match the order of VCF
file paths in \code{files}. If \code{NULL}(default), this function will
remove all of the path up to and including the last path separator (if any)
in \code{files} and file paths without extensions (and the leading dot)
will be used as the names of the VCF files.}

\item{tumor.col.names}{Optional. Character vector of column names in VCFs
which contain the tumor sample information. The order of names in
\code{tumor.col.names} should match the order of VCFs specified in
\code{files}. If \code{tumor.col.names} is equal to \code{NA}(default),
this function will use the 10th column in all the VCFs to calculate VAFs.
See \code{\link{GetMutectVAF}} for more details.}

\item{flag.mismatches}{Optional. If > 0, then if there are mismatches to
references in the ID (insertion/deletion) VCF, generate messages showing
the mismatched rows and continue. Otherwise \code{stop} if there are
mismatched rows. See \code{\link{AnnotateIDVCF}} for more details.}
}
\value{
A list of 3 SBS catalogs (one each for 96, 192, and 1536), 3 DBS
  catalogs (one each for 78, 136, and 144) and ID catalog. If trans.ranges =
  NULL, SBS 192 and DBS 144 catalog will not be generated. Each catalog has
  attributes added. See \code{\link{as.catalog}} for more details.
}
\description{
Create 3 SBS catalogs (96, 192, 1536), 3 DBS catalogs (78, 136, 144) and
Indel catalog from the Mutect VCFs specified by \code{files}
}
\details{
This function calls \code{\link{VCFsToSBSCatalogs}},
\code{\link{VCFsToDBSCatalogs}} and \code{\link{VCFsToIDCatalogs}}
}
\note{
SBS 192 and DBS 144 catalogs include only mutations in transcribed
  regions. In ID (small insertion and deletion) catalogs, deletion repeat sizes
  range from 0 to 5+, but for plotting and end-user documentation deletion
  repeat sizes range from 1 to 6+.
}
\section{Comments}{

To add or change attributes of the catalog, you can use function
\code{\link[base]{attr}}. \cr For example, \code{attr(catalog, "abundance")
<- custom.abundance}.
}

\examples{
file <- c(system.file("extdata/Mutect-vcf",
                      "Mutect.GRCh37.s1.vcf",
                      package = "ICAMS"))
if (requireNamespace("BSgenome.Hsapiens.1000genomes.hs37d5", quietly = TRUE)) {
  catalogs <- MutectVCFFilesToCatalog(file, ref.genome = "hg19", 
                                      trans.ranges = trans.ranges.GRCh37,
                                      region = "genome")}
}
