% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{revc}
\alias{revc}
\title{Reverse complement every string in \code{string.vec}.}
\usage{
revc(string.vec)
}
\arguments{
\item{string.vec}{A character vector.}
}
\value{
A character vector with the reverse complement of every
  string in \code{string.vec}.
}
\description{
Based on \code{\link{reverseComplement}}.
Handles IUPAC ambiguity codes but not "u" (uracil). \cr
(see <https://en.wikipedia.org/wiki/Nucleic_acid_notation>).
}
\examples{
revc("aTgc") # GCAT

# A vector and strings with ambiguity codes
revc(c("ATGC", "aTGc", "wnTCb")) # GCAT GCAT VGANW

\dontrun{
revc("ACGU") # An error}
}
