% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/INDELS_related_functions.R
\name{FindMaxRepeatDel}
\alias{FindMaxRepeatDel}
\title{Return the number of repeat units in which a deletion
is embedded.}
\usage{
FindMaxRepeatDel(context, rep.unit.seq, pos)
}
\arguments{
\item{context}{A string that embeds \code{rep.unit.seq} at position
\code{pos}}

\item{rep.unit.seq}{A substring of \code{context} at \code{pos}
to \code{pos + nchar(rep.unit.seq) - 1}, which is the repeat
 unit sequence.}

\item{pos}{The position of \code{rep.unit.seq} in \code{context}.}
}
\value{
The number of repeat units in which \code{rep.unit.seq} is
embedded, not including
the input rep.unit.seq in the count.
}
\description{
Return the number of repeat units in which a deletion
is embedded.
}
\details{
For example \code{FindMaxRepeatDel("xyaczt", "ac", 3)}
returns 0.

If
\code{substr(context, pos, pos + nchar(rep.unit.seq) - 1) != rep.unit.seq}
 then stop.

If this functions returns 0, then it is necessary to
  look for microhomology.
}
\keyword{internal}
