% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCF_to_catalog_functions.R
\name{VCFsToDBSCatalogs}
\alias{VCFsToDBSCatalogs}
\title{Create DBS catalogs from VCFs}
\usage{
VCFsToDBSCatalogs(list.of.DBS.vcfs, ref.genome, trans.ranges = NULL,
  region = "unknown")
}
\arguments{
\item{list.of.DBS.vcfs}{List of in-memory data frames of pure DBS mutations
-- no SBS or 3+BS mutations. The list names will be the sample ids in the
output catalog.}

\item{ref.genome}{A \code{ref.genome} argument as described in
\code{\link{ICAMS}}.}

\item{trans.ranges}{a \code{\link[data.table]{data.table}} which contains
transcript range and strand information. Please refer to
\code{\link{TranscriptRanges}} for more details.}

\item{region}{A character string designating a genomic region;
see \code{\link{as.catalog}} and \code{\link{ICAMS}}.}
}
\value{
A list of 3 DBS catalogs, one each for 78, 144, 136: catDBS78
  catDBS144 catDBS136. If trans.ranges = NULL, DBS 144 catalog will not be
  generated. Each catalog has attributes added. See \code{\link{as.catalog}}
  for more details.
}
\description{
Create a list of 3 catalogs (one each for DBS78, DBS144 and DBS136)
out of the contents in list.of.DBS.vcfs. The VCFs must not contain
any type of mutation other then DBSs.
}
\note{
DBS 144 catalog only contains mutations in transcribed regions.
}
\examples{
file <- c(system.file("extdata",
                      "Mutect.GRCh37.vcf",
                      package = "ICAMS"))
list.of.DBS.vcfs <- ReadAndSplitMutectVCFs(file)$DBS
catalogs.DBS <- VCFsToDBSCatalogs(list.of.DBS.vcfs, ref.genome = "hg19",
                                  trans.ranges = trans.ranges.GRCh37,
                                  region = "genome")
}
