% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/INDELS_related_functions.R
\name{AddAndCheckSequenceID}
\alias{AddAndCheckSequenceID}
\title{Add sequence context to a data frame with ID (insertion/deletion) mutation records,
 and confirm that they match the given reference genome.}
\usage{
AddAndCheckSequenceID(df, ref.genome, flag.mismatches = 0)
}
\arguments{
\item{df}{A data frame storing mutation records of a VCF file
 containing only insertions and deletions. This function expects that
 there is a "context base" to the left, for example REF = ACG, ALT = A
(deletion of CG) or REF = A, ALT = ACC (insertion of CC).}

\item{ref.genome}{A \code{ref.genome} argument as described in
\code{\link{ICAMS}}.}

\item{flag.mismatches}{If > 0, if there are mismatches to references, print
out the mismatched rows and continue.  Otherwise \code{stop}.}
}
\value{
A data frame with 2 new columns added to the input data frame:
\enumerate{
 \item \code{seq.context} The sequence embedding the variant.

 \item \code{seq.context.width} The width of \code{seq.context} to the left
}
}
\description{
Add sequence context to a data frame with ID (insertion/deletion) mutation records,
 and confirm that they match the given reference genome.
}
\keyword{internal}
