% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fooTransp.R
\name{PrandtTD}
\alias{PrandtTD}
\title{Prandt Number, Function of Temperature and Density}
\usage{
PrandtTD(T, D)
}
\arguments{
\item{T}{Temperature [ K ]}

\item{D}{Density [ kg m-3 ]}
}
\value{
The Prandt Number: Pr [ - ]

Error message (if an error occur)
}
\description{
The function \code{PrandtTD(T,D)} computes the Prandt Number, i.e., 
     the product of the dynamic viscosity by the specific isobaric heat capacity,
     divided by the thermal conductivity of water for given T [K] and D [kg/m3].
}
\details{
This function calls a Fortran DLL that computes the Prandt Number, valid from 
    the triple point to the pressure of 1000 MPa and temperature of 1173.15K.
}
\examples{
T <- 500.
D <- 838.025
Pran <- PrandtTD(T,D)
Pran

}
