% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fooOth.R
\name{CT}
\alias{CT}
\title{Third Virial Coefficient (C), Function of Temperature}
\usage{
CT(T)
}
\arguments{
\item{T}{Temperature [K]}
}
\value{
The second virial coefficient: C [ m3 kg-1 ]**2 and an Error Message 
    (if an error occur: \link{errorCodes})
}
\description{
The function \code{CT(T)} returns the third virial coefficient,
     C [ m3 kg-1 ]**2, for a given T [K].
}
\details{
This function calls a Fortran DLL that solves the Helmholtz Energy Equation. 
    in accordance with the Revised Release on the IAPWS Formulation 1995 for the 
    Thermodynamic Properties of Ordinary Water Substance for General and Scientific
    Use (June 2014) developed by the International Association for the Properties of
    Water and Steam,  \url{http://www.iapws.org/relguide/IAPWS-95.html}. It is valid  
    from the triple point to the pressure of 1000 MPa and temperature of 1273.
}
\examples{
T <- 500.
C_T <- CT(T)
C_T

}
