% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RectangleRegression.R
\name{RectangleRegression}
\alias{RectangleRegression}
\title{Return parameters of rectangle regression}
\usage{
RectangleRegression(
  x1,
  x2,
  replicate = 1000,
  x1new = seq(from = min(x1), to = max(x1), length.out = 100)
)
}
\arguments{
\item{x1}{The first series of data}

\item{x2}{The second series of data}

\item{replicate}{Number of replicates for bootstrap}

\item{x1new}{Values for x1 to generate x2}
}
\value{
A list with parameters of rectangle regression
}
\description{
Fit a line using least rectangle method.
}
\details{
RectangleRegression performs rectangle regression
}
\examples{
x1 <- runif(100, min=10, max=20)
x2 <- runif(100, min=10, max=20)+x1

rectreg <- RectangleRegression(x1, x2)

plot(x=x1, y=x2, bty="n", las=1, xlim=c(10, 20), ylim=c(20, 40))
abline(a=rectreg$par["Intercept"], b=rectreg$par["Slope"], lwd=2)
par(xpd=FALSE)
lines(rectreg$x2new["x1new", ], rectreg$x2new["50\%", ])
lines(rectreg$x2new["x1new", ], rectreg$x2new["2.5\%", ], lty=2)
lines(rectreg$x2new["x1new", ], rectreg$x2new["97.5\%", ], lty=2)

abline(a=rectreg$Intercept[1], b=rectreg$Slope[3], col="red")
abline(a=rectreg$Intercept[3], b=rectreg$Slope[1], col="red")

}
\author{
Marc Girondot
}
\concept{Rectangle Regression}
