% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RM_delete.R
\name{RM_delete}
\alias{RM_delete}
\title{Delete a results managment or a result within a results managment from an object}
\usage{
RM_delete(
  x = stop("An object with results managment must be provided"),
  RM = "RM",
  RMname = stop("A name must be provided"),
  valuename = NULL
)
}
\arguments{
\item{x}{The object to delete a results managment}

\item{RM}{The name of results managment stored}

\item{RMname}{The name of the result that will be deleted or its rank}

\item{valuename}{The name of the result that will be deleted}
}
\value{
The original object with the deleted results managment
}
\description{
Return the original object with the deleted results managment or result.
}
\details{
RM_delete deletes a results managment or a result within a results managment from an object
}
\examples{
\dontrun{
library("HelpersMG")
# Let an object of class objclass being created
obj <- list(A=100, name="My object")
class(obj) <- "objclass"
# And now I create a RM to this object
obj <- RM_add(x=obj, RMname="NewAnalysis1")
obj <- RM_add(x=obj, RMname="NewAnalysis2")
RM_list(obj)
obj <- RM_delete(x=obj, RMname="NewAnalysis1")
RM_list(obj)
obj <- RM_delete(x=obj, RMname=1)
RM_list(obj)
obj <- RM_add(x=obj, RMname="NewAnalysis1", valuename="V1", value=100)
RM_list(obj)
RM_get(x=obj, RMname="NewAnalysis1", valuename="V1")
obj <- RM_add(x=obj, RMname="NewAnalysis1", valuename="V2", value=200)
RM_get(x=obj, RMname="NewAnalysis1", valuename="V2")
obj <- RM_delete(x=obj, RMname="NewAnalysis1", valuename="V1")
RM_get(x=obj, RMname="NewAnalysis1", valuename="V1")
RM_get(x=obj, RMname="NewAnalysis1", valuename="V2")
}
}
\seealso{
Other Results Managment: 
\code{\link{RM_add}()},
\code{\link{RM_duplicate}()},
\code{\link{RM_get}()},
\code{\link{RM_list}()}
}
\author{
Marc Girondot
}
\concept{Results Managment}
