% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RM_list.R
\name{RM_list}
\alias{RM_list}
\title{Return the list of results managment of an object.}
\usage{
RM_list(
  x = stop("An object with results managment must be provided"),
  RM = "RM",
  silent = FALSE,
  max.level = FALSE
)
}
\arguments{
\item{x}{The object to add a results managment}

\item{RM}{The name of results managment stored}

\item{silent}{Should the results be shown ?}

\item{max.level}{If TRUE, will return all list element of the objects}
}
\value{
A list with the names of results stored in an object
}
\description{
RM_list returns the list of results managment of an object.
}
\details{
RM_list returns the list of results managment of an object
}
\examples{
\dontrun{
library("HelpersMG")
# Let an object of class objclass being created
obj <- list(A=100, name="My object")
class(obj) <- "objclass"
# And now I create a RM to this object
obj <- RM_add(x=obj, RMname="NewAnalysis1")
RM_list(obj)
obj <- RM_add(x=obj, RMname="NewAnalysis2")
RM_list(obj)
obj <- RM_add(x=obj, RMname="NewAnalysis2", valuename="V1", value=100)
RM_get(x=obj, RMname="NewAnalysis2", valuename="V1")
obj <- RM_add(x=obj, RMname="NewAnalysis2", valuename="V1", value=200)
RM_get(x=obj, RMname="NewAnalysis2", valuename="V1")
obj <- RM_add(x=obj, RMname="NewAnalysis2", valuename="V2", value=300)
RM_get(x=obj, RMname="NewAnalysis2", valuename="V2")
RM_list(obj)
rmlist <- RM_list(obj, max.level=TRUE)
rmlist
}
}
\seealso{
Other Results Managment: 
\code{\link{RM_add}()},
\code{\link{RM_delete}()},
\code{\link{RM_duplicate}()},
\code{\link{RM_get}()}
}
\author{
Marc Girondot
}
\concept{Results Managment}
