% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newdbeta.R
\name{newdbeta}
\alias{newdbeta}
\title{Density for the Beta distributions.}
\usage{
newdbeta(x, mu = NULL, v = NULL, shape1, shape2, ncp = 0,
  log = FALSE)
}
\arguments{
\item{x}{vector of quantiles.}

\item{mu}{mean of the Beta distribution.}

\item{v}{variance of the Beta distribution.}

\item{shape1}{non-negative parameters of the Beta distribution.}

\item{shape2}{non-negative parameters of the Beta distribution.}

\item{ncp}{non-centrality parameter.}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}
}
\value{
newdbeta gives the density for the Beta distributions
}
\description{
Density for the Beta distribution with parameters mu and v or shape1 and 
shape2 (and optional non-centrality parameter ncp).
}
\details{
newdbeta returns the density for the Beta distributions

The Beta distribution with parameters shape1 = a and shape2 = b has density \cr
gamma(a+b)/(gamma(a)gamma(b))x^(a-1)(1-x)^(b-1)\cr
for a > 0, b > 0 and 0 <= x <= 1 where the boundary values at x=0 or x=1 are defined as by 
continuity (as limits).\cr
The mean is a/(a+b) and the variance is ab/((a+b)^2 (a+b+1)). These moments and all 
distributional properties can be defined as limits.
}
\examples{
pi <- rbeta(100, shape1=0.48, shape2=0.12)
hist(pi, freq=FALSE, breaks=seq(from=0, to=1, by=0.1), ylim=c(0, 8), las=1)
library("HelpersMG")
mx <- ScalePreviousPlot()$ylim["end"]/
      max(newdbeta(seq(from=0.01, to=0.99, by=0.01), mu = 0.8, v=0.1))
curve(newdbeta(x, mu = 0.8, v=0.1)*mx, add=TRUE, col="red")
}
\author{
Marc Girondot
}
