% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BD_shift.R
\name{format_metadata}
\alias{format_metadata}
\title{Format phyloseq metadata for calculating BD range overlaps.}
\usage{
format_metadata(physeq, ex = "Substrate=='12C-Con'", rep = "Replicate")
}
\arguments{
\item{physeq}{Phyloseq object}

\item{ex}{Expression for selecting the control samples to
compare to the non-control samples.}

\item{rep}{Column specifying gradient replicates. If the column
is not present, then all are considered "Replicate=1"}
}
\value{
a data.frame object of formatted metadata
}
\description{
Format phyloseq metadata for calculating BD range overlaps.
}
\examples{
\dontrun{
data(physeq_S2D1)
ex = "Substrate=='12C-Con'"
metadata = format_metadata(physeq_S2D1, ex)
}

}
